{*
* 2007-2023 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* @author    Aisyncrasy
* @copyright 2025 Modasyncrasy S.L.
*}


{* ----- ROW 1: Original Product Image Gallery (Scrollable) ----- *}
<div class="row" style="margin-bottom: 20px;">
    <div class="col-md-12">
        <h4><span>{l s='Original Product Images - Click to Select as Base' mod='aiimageedit'}</span>            <a href="https://aisyncrasy.com/ps_aiimageedit_help?lang={$prestashop_lang_iso_code|escape:'html':'UTF-8'}" target="_blank" style="font-size: 0.8rem; font-weight: normal; vertical-align: middle;margin-left:1rem;">
                ({l s='Help' mod='aiimageedit'})
            </a></h4>
        {if $ai_product_images|count > 0}

<div id="ai-original-image-gallery" class="d-flex flex-row flex-nowrap" style="overflow-x: auto; padding-bottom: 15px; border: 1px solid #eee;">
    {foreach from=$ai_product_images item=image name=prodImagesLoop}		
        <div class="ai-image-item-wrapper text-center" style="min-width: 130px; margin-right: 10px; padding: 5px;">
            <div class="ai-image-container">
                <img src="{$image.url|escape:'html':'UTF-8'}"
                     alt="{$image.legend|escape:'html':'UTF-8'}"
                     class="img-thumbnail ai-gallery-selectable-image"
                     data-image-id="{$image.id_image|intval}"
                     data-original-url="{$image.original_url|escape:'html':'UTF-8'}"
                     data-width="{$image.width|intval}"
                     data-height="{$image.height|intval}"
                     data-type="original"
                     data-legend="{$image.legend|escape:'html':'UTF-8'}"
                     style="cursor: pointer; max-height: 120px; width:auto; object-fit: contain;"
                     title="{l s='Select as base:' mod='aiimageedit'} {$image.legend|escape:'html':'UTF-8'}">
                <div class="ai-zoom-icon" data-gallery-type="original-gallery">
                    <i class="material-icons">zoom_in</i>
                </div>
            </div>
            <p class="text-muted small image-dimensions" style="margin-top: 2px; margin-bottom: 0;">
                {if $image.width && $image.height}{$image.width|intval}x{$image.height|intval} px{else}--{/if}
            </p>
        </div>
    {/foreach}
</div>
        {else}
            <div class="alert alert-info">{l s='This product has no original images.' mod='aiimageedit'}</div>
        {/if}
    </div>
</div>

{* ----- ROW 2: Selected Base Image (Position 1) & AI Tools ----- *}
<div class="row">
    {* --- Column 1: Selected Base Image (Position 1) & Results --- *}
    {* --- Column 1: Selected Base Image (Position 1) --- *}
    <div class="col-md-3">
        <h4>{l s='Base Image' mod='aiimageedit'}</h4>
        <div id="ai-position-1-base-image-area" class="text-center" style="border: 0px dashed #007bff; padding: 15px; margin-bottom: 20px; min-height: 200px; display: flex; flex-direction: column; align-items: center; justify-content: center;">
		   <div id="position-1-container" class="ai-image-container">
            <img id="ai-position-1-preview" src="{if $ai_selected_image_initial}{$ai_selected_image_initial.original_url|escape:'html':'UTF-8'}{/if}" 
                 alt="{l s='Selected Base Image' mod='aiimageedit'}" class="img-fluid" 
                 style="max-height: 450px; margin-bottom: 5px; {if !$ai_selected_image_initial}display:none;{/if} cursor:pointer;"
                 title="{l s='Click to enlarge current base image' mod='aiimageedit'}">
				     <div class="ai-zoom-icon" data-gallery-type="position-1">
        <i class="material-icons">zoom_in</i>
    </div>
	</div>
            <p id="ai-position-1-info" class="text-muted small" style="margin-bottom: 5px;">
                {if $ai_selected_image_initial}
                    {l s='Original Product Image' mod='aiimageedit'}
                {else}
                    {l s='Click an image from gallery above or a result below.' mod='aiimageedit'}
                {/if}
            </p>
            <p id="ai-position-1-dimensions" class="text-muted small font-weight-bold">
                 {if $ai_selected_image_initial && $ai_selected_image_initial.width && $ai_selected_image_initial.height}
                    {$ai_selected_image_initial.width|intval}x{$ai_selected_image_initial.height|intval} px
                 {/if}
            </p>
        </div>
    </div>

    {* --- Column 2: AI Tools (Generation & Upscaling) --- *}
    <div class="col-md-9">
        <div class="row">
            {* Sub-Column A: AI Generation Parameters *}
            <div class="col-md-6">
                <h4>{l s='AI Image Generation (Edit)' mod='aiimageedit'}</h4>
                <p class="small text-muted">{l s='Uses the "Base Image" as input.' mod='aiimageedit'}</p>
                
                <div class="form-group">
                    <label for="ai_prompt">{l s='Prompt' mod='aiimageedit'} <span class="text-danger">*</span></label>
                    <textarea id="ai_prompt" name="ai_prompt" class="form-control" rows="3" placeholder="{l s='e.g., make the background a sunny beach' mod='aiimageedit'}" title="{l s='Text description of what you want to change' mod='aiimageedit'}">{$ai_default_params.prompt|escape:'html':'UTF-8'}</textarea>
                </div>
                <div class="form-group">
                    <label for="ai_num_images">{l s='Number of Images to Generate' mod='aiimageedit'} (<span id="ai_num_images_value">{$ai_default_params.num_images|default:1|intval}</span>)</label>
                    <input type="range" id="ai_num_images" name="ai_num_images" class="form-control-range" min="1" max="4" value="{$ai_default_params.num_images|default:1|intval}" title="{l s='Number of image variations to generate' mod='aiimageedit'}">
                </div>

                <div class="card" style="margin-bottom:15px;">
                    <div class="card-header" id="advancedGenHeader" style="padding: .5rem 1rem; cursor:pointer;" data-toggle="collapse" data-target="#advancedGenParamsContainer" aria-expanded="false" aria-controls="advancedGenParamsContainer">
                        <h5 class="mb-0" style="font-size: 0.9rem;">
                            {l s='Advanced Generation Settings' mod='aiimageedit'} <i class="material-icons expand-icon-gen" style="vertical-align: middle; font-size: 1.2rem;">expand_more</i>
                        </h5>
                    </div>
                    <div id="advancedGenParamsContainer" class="collapse">
                        <div class="card-body" style="padding: 1rem;">
                            <div class="form-group">
                                <label for="ai_moderation_level">{l s='Moderation Level' mod='aiimageedit'} (<span id="ai_moderation_level_value">{$ai_default_params.moderation_level|default:2|intval}</span>)</label>
                                <input type="range" id="ai_moderation_level" name="ai_moderation_level" class="form-control-range" min="0" max="6" value="{$ai_default_params.moderation_level|default:2|intval}" title="{l s='0: strict, 6: permissive' mod='aiimageedit'}">
                            </div>
                            <div class="form-group">
                                <label for="ai_seed">{l s='Seed (Optional)' mod='aiimageedit'}</label>
                                <input type="text" id="ai_seed" name="ai_seed" class="form-control form-control-sm" value="{$ai_default_params.seed|escape:'html':'UTF-8'}" placeholder="{l s='e.g., 12345 or leave empty' mod='aiimageedit'}" title="{l s='Optional seed for reproducibility' mod='aiimageedit'}">
                            </div>
                            <div class="form-group">
                                <label for="ai_output_format">{l s='Output Format (BFL)' mod='aiimageedit'}</label>
                                <select id="ai_output_format" name="ai_output_format" class="form-control form-control-sm" title="{l s='Format of the BFL output image' mod='aiimageedit'}">
                                    <option value="jpeg" {if $ai_default_params.output_format == 'jpeg'}selected{/if}>{l s='JPEG' mod='aiimageedit'}</option>
                                    <option value="png" {if $ai_default_params.output_format == 'png'}selected{/if}>{l s='PNG' mod='aiimageedit'}</option>
                                </select>
                            </div>
							<div class="form-group">
                                <label for="ai_model">{l s='Model' mod='aiimageedit'}</label>
                                <select id="ai_model" name="ai_model" class="form-control form-control-sm" title="{l s='Pro=5 credits, Ultra=10 credits' mod='aiimageedit'}">
                                    <option value="Pro" {if $ai_default_params.model == 'Pro'}selected{/if}>{l s='Pro (5 Credits)' mod='aiimageedit'}</option>
                                    <option value="Ultra" {if $ai_default_params.model == 'Ultra'}selected{/if}>{l s='Ultra (10 Credits)' mod='aiimageedit'}</option>
                                    {* Puedes añadir más modelos aquí en el futuro *}
                                </select>
                                <p class="help-block text-muted small">{l s='The AI model to use for generation.' mod='aiimageedit'}</p>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="ai_prompt_upsampling" name="ai_prompt_upsampling" {if $ai_default_params.prompt_upsampling}checked{/if}>
                                <label class="form-check-label" for="ai_prompt_upsampling">
                                    {l s='Enable Prompt Upsampling' mod='aiimageedit'}
                                </label>
                                <p class="help-block text-muted small">{l s='May improve detail based on prompt during generation' mod='aiimageedit'}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" id="ai-generate-image-btn" class="btn btn-info btn-block" disabled>
                    <i class="material-icons">auto_awesome</i> {l s='Generate AI Images' mod='aiimageedit'}
                </button>
                <div id="ai-gen-status-message" class="alert" style="display:none; margin-top:10px; font-size:0.9em; padding: 0.5rem 3rem;"></div>
            </div>

            {* Sub-Column B: AI Upscaling Parameters *}
            <div class="col-md-6">
                <h4>{l s='AI Image Upscaling' mod='aiimageedit'}</h4>
                <p class="small text-muted">{l s='Uses the Base Image as input.' mod='aiimageedit'}</p>
                
                <div class="form-group">
                    <label>{l s='Scale Options' mod='aiimageedit'}</label>
                    <div class="form-check" style="margin-top:10px">
                        <input class="form-check-input ai-upscale-mode" type="radio" style="margin-top:10px" name="ai_upscale_mode_option" id="ai_upscale_to_specific" value="specific" {if $ai_default_params.upscale_target_specific}checked{/if}>
                        <label class="form-check-label" for="ai_upscale_to_specific">
                            {l s='Scale to original base dimensions:' mod='aiimageedit'} <span id="ai_upscale_target_dims_display">({l s='N/A' mod='aiimageedit'})</span>
                        </label>
                         <p class="help-block text-muted small">{l s='Upscales current image towards the dimensions of the initially selected original product image.' mod='aiimageedit'}</p>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input ai-upscale-mode" type="radio" name="ai_upscale_mode_option" id="ai_upscale_by_factor_2x" value="factor_2x" {if !$ai_default_params.upscale_target_specific && ($ai_default_params.upscale_factor|floatval) == 2.0}checked="checked"{/if}>
                        <label class="form-check-label" for="ai_upscale_by_factor_2x">
                            {l s='Scale current image x2' mod='aiimageedit'}
                        </label>
                    </div>
                    <div class="form-check" style="margin-top:10px;">
                        <input class="form-check-input ai-upscale-mode"  style="margin-top:13px;" type="radio" name="ai_upscale_mode_option" id="ai_upscale_by_custom" value="custom" {if !$ai_default_params.upscale_target_specific && ($ai_default_params.upscale_factor|floatval) != 2.0}checked="checked"{/if}>
                        <label class="form-check-label" for="ai_upscale_by_custom"  style="margin-top:10px;" >
                            {l s='Custom Scale x' mod='aiimageedit'}
                        </label>
                        {* El campo de texto solo será visible si esta opción está seleccionada *}
                        <div id="ai_custom_scale_input_wrapper" style="display: inline-block; margin-left: 10px;">
                            <input type="number" step="0.1" min="1" max="4" id="ai_custom_scale_value" class="form-control form-control-sm" style="width: 100px;" value="{$ai_default_params.upscale_factor|floatval}">
                        </div>
                    </div>
                </div>
                 <div class="form-check" style="margin-top:10px; margin-bottom:15px;">
                    <input class="form-check-input" type="checkbox" id="ai_upscale_face_enhance" name="ai_upscale_face_enhance" {if $ai_default_params.upscale_face_enhance}checked{/if}>
                    <label class="form-check-label" for="ai_upscale_face_enhance">
                        {l s='Face Enhance' mod='aiimageedit'}
                    </label>
                </div>
                <button type="button" id="ai-upscale-image-btn" style="transform: translateY(8px);" class="btn btn-primary btn-block" disabled>
                    <i class="material-icons">aspect_ratio</i> {l s='Scale with AI' mod='aiimageedit'}
                </button>
                <div id="ai-upscale-status-message" class="alert" style="display:none; margin-top:10px; font-size:0.9em; padding: 0.5rem 3rem;"></div>
            </div>
        </div> {* End .row for gen/upscale columns *}

<div class="col-md-12 text-center" style="margin-top: 15px;">
    <div id="ai-action-callout-area" style="display: none;"></div>
</div>
        {* Configuration Management & Refresh Button (as before, ensure they fit the layout) *}
        {* ... Your existing config management HTML ... *}
        {* ... Your refresh button HTML ... *}
         <div class="row" style="margin-top: 20px; border-top: 1px solid #eee; padding-top:15px;">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header" id="manageConfigHeader" style="padding: .5rem 1rem; cursor:pointer;" data-toggle="collapse" data-target="#manageConfigContent" aria-expanded="false" aria-controls="manageConfigContent">
                        <h5 class="mb-0" style="font-size: 0.9rem;">
                           {l s='Manage AI Parameter Configurations' mod='aiimageedit'} <i class="material-icons expand-icon-config" style="vertical-align: middle; font-size: 1.2rem;">expand_more</i>
                        </h5>
                    </div>
                    <div id="manageConfigContent" class="collapse">
                        <div class="card-body">
                                                        <div class="row">
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label for="ai_saved_configs_dropdown">{l s='Load Saved Configuration' mod='aiimageedit'}</label>
                                        <select id="ai_saved_configs_dropdown" class="form-control form-control-sm">
                                            <option value="">{l s='-- Select a Configuration --' mod='aiimageedit'}</option>
                                            {if isset($ai_saved_configs) && $ai_saved_configs|count > 0}
                                                {foreach from=$ai_saved_configs item=config}
                                                    <option value="{$config.id_aiimageedit_config|intval}">{$config.name|escape:'html':'UTF-8'}</option>
                                                {/foreach}
                                            {/if}
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-7" style="padding-top: 25px;">
                                    <button type="button" id="ai-load-config-btn" class="btn btn-secondary btn-sm"><i class="material-icons">open_in_new</i> {l s='Load' mod='aiimageedit'}</button>
                                    <button type="button" id="ai-delete-config-btn" class="btn btn-danger btn-sm"><i class="material-icons">delete</i> {l s='Delete' mod='aiimageedit'}</button>
                                </div>
                            </div>
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label for="ai_new_config_name">{l s='Configuration Name to Save/Update' mod='aiimageedit'}</label>
                                        <input type="text" id="ai_new_config_name" class="form-control form-control-sm" placeholder="{l s='Enter new or existing name' mod='aiimageedit'}">
                                    </div>
                                </div>
                                <div class="col-md-7" style="padding-top: 25px;">
                                    <button type="button" id="ai-save-config-btn" class="btn btn-primary btn-sm"><i class="material-icons">save</i> {l s='Save/Update Config' mod='aiimageedit'}</button>
                                    <button type="button" id="ai-save-default-btn" class="btn btn-outline-secondary btn-sm"><i class="material-icons">star</i> {l s='Set as Default' mod='aiimageedit'}</button>
                                </div>
                            </div>
                            <div id="ai-config-message-area" style="margin-top:10px; font-size:0.9em;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div> {* End Right Column Tools .col-md-8 *}
</div> {* End Main .row *}

{* ----- ROW 3: Generated / Upscaled Results Area ----- *}
<div class="row" style="margin-top: 30px; padding-top:15px; border-top: 2px solid #007bff;">
    <div class="col-md-12">
        <h4>{l s='Generated / Upscaled Results - Click to use as new Base Image' mod='aiimageedit'}</h4>
        <div id="ai-results-area" class="row">
            <p class="text-muted text-center if-empty-results" style="width:100%; padding: 20px;">{l s='No results yet. Generate or upscale an image using the tools above.' mod='aiimageedit'}</p>
            {* JS will populate this with result cards, max 6 per row *}
        </div>
    </div>
</div>

{* Modal for Enlarged Image (as before, ensure it uses Bootstrap 4+ classes if your BO theme does) *}
<div class="modal fade" id="aiImageEnlargeModal" tabindex="-1" role="dialog" aria-labelledby="aiImageEnlargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="aiImageEnlargeModalLabel"></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
      </div>
      <div class="modal-body text-center position-relative" id="aiModalBody">
        {* Navigation Arrows *}
        <button type="button" class="btn btn-light modal-nav-arrow prev" id="aiModalPrevImage"><i class="material-icons">chevron_left</i></button>
        <button type="button" class="btn btn-light modal-nav-arrow next" id="aiModalNextImage"><i class="material-icons">chevron_right</i></button>

        {* Compare & Zoom Controls *}
        <div class="modal-controls-top-right">
            <div class="ai-compare-icon" id="aiModalCompareIcon" title="{l s='Hold to compare with base image' mod='aiimageedit'}">
                <i class="material-icons">compare_arrows</i>
            </div>
            <div class="ai-zoom-control" id="aiModalZoomIn" title="{l s='Zoom In' mod='aiimageedit'}">
                <i class="material-icons">add</i>
            </div>
            <div class="ai-zoom-control" id="aiModalZoomOut" title="{l s='Zoom Out' mod='aiimageedit'}">
                <i class="material-icons">remove</i>
            </div>
        </div>

        {* NEW: Container for Pan & Zoom *}
        <div id="aiPanZoomContainer" style="width:100%; height:80vh; overflow:hidden; cursor:grab;">
            <img id="aiEnlargedImageSrc" src="" alt="{l s='Enlarged view' mod='aiimageedit'}" style="max-width: 100%; max-height: 100%; display: block; margin: auto; transform-origin: center center; transition: transform 0.2s ease;">
        </div>

      </div>
    </div>
  </div>
</div>

<style>
.action-callout-button {
    /* Aplicaremos esta clase a los botones que queremos que brillen */
    animation: pulse-glow 2s infinite;
}

@keyframes pulse-glow {
    0% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); /* Verde para "Buy Credits" */
    }
    70% {
        box-shadow: 0 0 0 15px rgba(40, 167, 69, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);
    }
}

/* Podemos hacer una versión diferente para el botón de "Subscribe" (amarillo) */
.action-callout-button.btn-warning {
    animation-name: pulse-glow-warning;
}

@keyframes pulse-glow-warning {
    0% {
        box-shadow: 0 0 0 0 rgba(255, 193, 7, 0.7); /* Amarillo para "Subscribe" */
    }
    70% {
        box-shadow: 0 0 0 15px rgba(255, 193, 7, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(255, 193, 7, 0);
    }
}
    .ai-image-item-wrapper, .ai-result-card { padding: 5px; }
    .ai-result-card .card { height: 100%; }
    .ai-result-card img { margin-bottom: 5px !important; } /* Override PS default thumbnail margin */
    .ai-result-card .image-dimensions { margin-top: 0; margin-bottom: 5px; }
    .ai-image-status-overlay { /* For status over generated image placeholder */
        position: absolute; top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(255,255,255,0.8); display: flex;
        align-items: center; justify-content: center; text-align: center;
        padding: 10px; font-size: 0.9em; z-index:10; display:none; /* Initially hidden */
    }
    .ai-result-card img.loading + .ai-image-status-overlay { display:flex; } /* Show status when image is loading/polling */


    .ai-gallery-selectable-image.selected-source, /* For top original gallery */
    .ai-result-selectable-image.selected-source,   /* For bottom results gallery */
    #ai-position-1-preview.is-active-base { /* If Position 1 has an image */
        border: 3px solid #007bff !important;
        box-shadow: 0 0 8px rgba(0,123,255,0.7);
    }
	
    #ai-original-image-gallery .ai-image-item-wrapper {
        transition: transform 0.1s ease-in-out;
    }
    #ai-original-image-gallery .ai-image-item-wrapper:hover img {
        transform: scale(1.05);
    }

    /* Style for result cards in #ai-results-area */
    .ai-result-card-item { /* This will be the col-md-2 or similar */
        padding: 5px;
        margin-bottom: 10px;
    }
    .ai-result-card-item .card {
        height: 100%;
        display: flex;
        flex-direction: column;
    }
    .ai-result-card-item img.ai-result-selectable-image {
        max-height: 150px; /* Adjust as needed */
        width: 100%;
        object-fit: contain;
        cursor: pointer;
        margin-bottom: 5px;
    }
    .ai-result-card-item .image-dimensions {
        font-size: 0.8em;
        margin-top: 0;
        margin-bottom: 5px;
    }
    .ai-result-card-item .btn-sm {
        font-size: 0.8em;
        padding: 0.25rem 0.5rem;
    }
     .ai-result-card-item .card-footer {
        padding: 0.5rem;
        margin-top: auto; /* Pushes footer to bottom if card body has flex-grow */
    }
    .ai-gallery-selectable-image.selected, 
    .ai-result-selectable-image.selected { /* For results area */
        border: 3px solid #007bff !important; /* More prominent selection */
        box-shadow: 0 0 8px rgba(0,123,255,0.7);
    }
    #ai-position-1-base-image-area img {
        transition: transform 0.2s ease-in-out;
    }
    #ai-position-1-base-image-area img:hover {
        transform: scale(1.05);
    }

    .ai-selectable-image.selected, .ai-result-selectable-image.selected {
        border: 3px solid #00aff0 !important;
        box-shadow: 0 0 8px rgba(0,175,240,0.7);
    }

    /* Styles for modal navigation arrows */
    .modal-nav-arrow {
        position: absolute; top: 50%; transform: translateY(-50%); z-index: 1051;
        background-color: rgba(0,0,0,0.3); color:white; border: none; border-radius: 50%;
        width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; padding: 0;
    }
    .modal-nav-arrow:hover { background-color: rgba(0,0,0,0.5); }
    .modal-nav-arrow.prev { left: 5px; }
    .modal-nav-arrow.next { right: 5px; }
    #aiImageEnlargeModal .modal-body { padding-left: 50px; padding-right: 50px; }

	.alert .material-icons {
		float: left;
		margin-right: 8px;
	}

    /* Spinner for buttons */
    @keyframes spin-ai { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    .icon-spin-ai { display: inline-block; animation: spin-ai 1s linear infinite; vertical-align: middle; }
	
	/* Container for image + magnifier icon */
.ai-image-container {
    position: relative;
    display: inline-block; /* Or block, depending on layout */
    line-height: 0; /* Prevents extra space below image */
}

/* The magnifier icon itself */
.ai-zoom-icon {
    position: absolute;
    top: 5px;
    right: 5px;
    z-index: 10;
    color: white;
    background-color: rgba(0, 0, 0, 0.5);
    border-radius: 50%;
    padding: 4px;
    cursor: pointer;
    opacity: 0; /* Hidden by default */
    transition: opacity 0.2s ease-in-out;
    display: flex;
    align-items: center;
    justify-content: center;
}

.ai-zoom-icon .material-icons {
    font-size: 20px; /* Adjust icon size */
}

.ai-image-container {
    overflow: hidden;
}

.ai-result-selectable-image {
    transition: transform 0.3s ease;
}

.ai-result-selectable-image:hover {
    transform: scale(1.05); /* Smaller zoom to prevent layout issues */
}

/* Show icon on hover */
.ai-image-container:hover .ai-zoom-icon {
    opacity: 1;
}

/* Compare Icon in Modal */
.ai-compare-icon {
    transform: translateY(20px);
    display: inline-flex!important
    z-index: 1052; /* Higher than modal content to be on top */
    color: white;
    background-color: rgba(0, 0, 0, 0.5);
    border-radius: 50%;
    padding: 6px;
    cursor: pointer;
    display: none; /* Hidden by default */
    transition: background-color 0.2s;
}
.ai-compare-icon:hover {
    background-color: rgba(0, 0, 0, 0.7);
}
.ai-compare-icon .material-icons {
    font-size: 24px;
}

.modal-controls-top-right {
    position: absolute;
    top: 10px;
    right: 10px;
    z-index: 1052;
    display: flex;
    flex-direction: column;
    gap: 8px; /* Space between buttons */
}

/* Compare and Zoom Icons */
.ai-compare-icon, .ai-zoom-control {
    color: white;
    background-color: rgba(0, 0, 0, 0.5);
    border-radius: 50%;
    width: 36px;
    height: 36px;
    cursor: pointer;
    display: none; /* Hidden by default, shown by JS */
    align-items: center;
    justify-content: center;
    transition: background-color 0.2s;
}

.ai-zoom-control {
  transform: translateY(100px);
  display: inline-flex!important
}
.ai-compare-icon:hover, .ai-zoom-control:hover {
    background-color: rgba(0, 0, 0, 0.7);
}
.ai-compare-icon .material-icons, .ai-zoom-control .material-icons {
    font-size: 22px;
}

/* Pan & Zoom Container */
#aiPanZoomContainer {
    position: relative; /* This is required for the new positioning model */
    width: 100%;
    height: 75vh; 
    overflow: hidden;
    cursor: grab;
    touch-action: none;
}

#aiPanZoomContainer.grabbing {
    cursor: grabbing;
}

#aiEnlargedImageSrc {
    /* Critical for pan/zoom logic */
    transform-origin: 0 0; /* Set transform origin to top-left for easier calculations */
    transition: transform 0.2s ease; /* Smooth transition for zoom buttons */
    /* Remove max-width/height from here, it will be controlled by JS/container */
    width: auto;
    height: auto;
    max-width: none;
    max-height: none;
}

</style>

<script type="text/javascript">
{literal}
    // ----- GLOBAL STATE VARIABLES -----
    var BFL_API_KEY = "{/literal}{$ai_api_key_bfl|escape:'javascript':'UTF-8'}{literal}";
	var USER_PLAN = "{/literal}{$ai_user_plan|escape:'javascript':'UTF-8'}{literal}";
    var USER_ID = "{/literal}{$ai_user_id|intval}{literal}";
	var prestashop_lang_iso = "{/literal}{$prestashop_lang_iso_code|escape:'javascript':'UTF-8'}{literal}";
    var currentBaseImage = { // This is "Position 1"
        id: null,           // Original PrestaShop image ID if applicable
        internalId: null,   // Unique ID for generated/upscaled images not yet saved
        type: null,         // 'original', 'generated', 'upscaled'
        url: null,          // Full URL for API input (original or result URL)
        displayUrl: null,   // URL for display in #ai-position-1-preview (can be thumbnail)
        width: null,
        height: null,
        legend: '',
        isAIResult: false   // True if this base image is from the #ai-results-area
    };
	
	var initialOriginalForUpscaleTarget = {
        id: null,
        width: null,
        height: null
    };
    var activePolls = 0; // A simple counter for all active polling intervals
    var aiGenPollingData = {}; // { internalTempId: { bflRequestId: '', iteration: 0, statusElId: '', previewElId: '', saveBtnElId: '' } }
    var aiUpscalePollingData = {}; // { internalTempId: { replicateRequestId: '', statusElId: '', previewElId: '', saveBtnElId: '' } }
    var mouse = { x: 0, y: 0 }; // Add this line
	var currentBaseImageLegend = '';
    var enlargedImageGallery = [];
    var currentEnlargedImageIndex = 0;
    var isModalForOriginals = false;
    var modalGallery = []; // Holds {src: '...', title: '...'} objects for the current modal view
    var modalCurrentIndex = 0;
   
    var originalZoomedImageSrc = '';
    // ----- PAN & ZOOM STATE VARIABLES -----
    var panZoomState = {
        scale: 1,
        translateX: 0,
        translateY: 0,
        isPannable: false,
        isPanning: false,
        start: { x: 0, y: 0 },
        imageNaturalWidth: 0,
        imageNaturalHeight: 0
    };
    var mouse = { x: 0, y: 0 };
	
    // ----- HELPER FUNCTIONS -----
    function gcd(a, b) { return b ? gcd(b, a % b) : a; }

    function getSpinnerHtml(size = '2rem') {
        return '<div class="text-center p-3"><i class="material-icons icon-spin-ai" style="font-size:' + size + ';">hourglass_empty</i></div>';
    }

    // --- NUEVO: Función para añadir dinámicamente una imagen a la galería original ---
    function addOriginalImageToGallery(imageData) {
        if (!imageData || !imageData.id_image) {
            console.error("AIIMAGEEDIT: Invalid image data received for gallery update.");
            return;
        }

        console.log("AIIMAGEEDIT: Adding new original image to gallery:", imageData);

        // Construye el HTML para la nueva miniatura
        const newImageHtml = `
            <div class="ai-image-item-wrapper text-center" style="min-width: 130px; margin-right: 10px; padding: 5px;">
                <div class="ai-image-container">
                    <img src="${imageData.url}"
                         alt="${imageData.legend.replace(/"/g, '"')}"
                         class="img-thumbnail ai-gallery-selectable-image"
                         data-image-id="${imageData.id_image}"
                         data-original-url="${imageData.original_url}"
                         data-width="${imageData.width || ''}"
                         data-height="${imageData.height || ''}"
                         data-type="original"
                         data-legend="${imageData.legend.replace(/"/g, '"')}"
                         style="cursor: pointer; max-height: 120px; width:auto; object-fit: contain;"
                         title="{/literal}{l s='Select as base:' mod='aiimageedit' js=1}{literal} ${imageData.legend.replace(/"/g, '"')}">
                    <div class="ai-zoom-icon" data-gallery-type="original-gallery">
                        <i class="material-icons">zoom_in</i>
                    </div>
                </div>
                <p class="text-muted small image-dimensions" style="margin-top: 2px; margin-bottom: 0;">
                    ${(imageData.width && imageData.height) ? `${imageData.width}x${imageData.height} px` : '--'}
                </p>
            </div>
        `;

        // Añade el nuevo elemento a la galería del DOM
        $('#ai-original-image-gallery').append(newImageHtml);
    }
	
	
	    function showInsufficientCreditsAction() {
        $('#ai-action-callout-area').empty().show(); // Limpiar y mostrar el área

        let buttonHtml = '';
        if (USER_PLAN === 'freemium') {
            // Lógica para el botón "Subscribe"
			const subscribeUrl = `https://aisyncrasy.com/ps_subscribe?user_id=${USER_ID}&lang=${prestashop_lang_iso}#${BFL_API_KEY}`;

			buttonHtml = `
				<a href="${subscribeUrl}"
				   target="_blank"  class="btn btn-lg btn-warning action-callout-button">
					<i class="material-icons">star</i> {/literal}{l s='You have run out of credits of your freemium plan. Subscribe to a Plan!' mod='aiimageedit' js=1}{literal}
        </a>
    `;
               
        } else {
            // Lógica para el botón "Buy More Credits"
            // Como esta URL es dinámica, usamos un botón que dispara un AJAX
            buttonHtml = `
                <button type="button" id="insufficientCreditsBuyBtn"  class="btn btn-lg btn-warning action-callout-button">
                    <i class="material-icons">add_shopping_cart</i> {/literal}{l s='You have run out of credits. Buy More!' mod='aiimageedit' js=1}{literal}
                </button>
            `;
        }
        
        $('#ai-action-callout-area').html(buttonHtml);
    }

    function updateButtonState($button, isLoading, originalHtmlContent = null) {
        if (isLoading) {
            if (originalHtmlContent) $button.data('original-html', originalHtmlContent);
            else if (!$button.data('original-html')) $button.data('original-html', $button.html());

            $button.prop('disabled', true).html('<i class="material-icons icon-spin-ai">hourglass_empty</i> {/literal}{l s="Processing..." mod="aiimageedit" js=1}{literal}');
        } else {
            $button.prop('disabled', false).html($button.data('original-html'));
        }
    }
	
    // --- FUNCIÓN DE AYUDA PARA MENSAJES DE ESTADO (SIMPLIFICADA) ---
    function showStatusMessage(type, message, duration = 0, target = 'gen') {
        // Determina a qué área de estado nos dirigimos
        const statusAreaId = (target === 'upscale') ? '#ai-upscale-status-message' : '#ai-gen-status-message';
        const $el = $(statusAreaId);
        
        // Simplemente ponemos el mensaje de texto, sin HTML extra ni iconos
        $el.text(message);
        
        // Eliminamos las clases de estado anteriores y añadimos la nueva
        $el.removeClass('alert-info alert-success alert-danger alert-warning').addClass('alert-' + type);
        
        // Mostramos el contenedor del mensaje
        $el.show();
        
        // Si se especifica una duración, lo ocultamos después de ese tiempo
        if (duration > 0) {
            setTimeout(function() {
                $el.fadeOut();
            }, duration);
        }
    }
    // ----- NEW HELPER FUNCTION for getting Base64 (The "Router") -----
    async function getBase64ForCurrentImage() {
        if (!currentBaseImage.url) {
            throw new Error('{/literal}{l s="No base image is selected." mod="aiimageedit" js=1}{literal}');
        }
        
        // If the image is an original product image from our own domain, we can try client-side conversion.
        if (currentBaseImage.type === 'original') {
            console.log("AIIMAGEEDIT: Getting Base64 via client-side Canvas for original image.");
			
            // Assuming this URL is from our own domain and won't have CORS issues.
            return await imageUrlToBase64Canvas(currentBaseImage.url);
        } else {
            // If it's a 'generated' or 'upscaled' image from an external API (bfl, replicate), use our server proxy.
            console.log("AIIMAGEEDIT: Getting Base64 via server-side proxy for external AI image.");
            return new Promise((resolve, reject) => {
                $.ajax({
                    url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        ajax: 1,
                        action: 'getImageAsBase64', // The new controller action
                        image_url: currentBaseImage.url,
                        token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                    },
                    success: function(response) {
                        if (response.success && response.base64) {
                            resolve(response.base64);
                        } else {
                            reject(new Error(response.message || '{/literal}{l s="Failed to get Base64 from server." mod="aiimageedit" js=1}{literal}'));
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        reject(new Error('{/literal}{l s="AJAX error while getting Base64:" mod="aiimageedit" js=1}{literal} ' + errorThrown));
                    }
                });
            });
        }
    }

    async function imageUrlToBase64Canvas(url) {
        // ... (your existing imageUrlToBase64Canvas, ensure all {l s='...'} are wrapped)
        // Example: reject(new Error('{/literal}{l s="Image load error for base64 conversion" mod="aiimageedit" js=1}{literal}'));
        return new Promise((resolve, reject) => {
            if (!url) {
                console.error('imageUrlToBase64Canvas: URL is empty or null.');
                reject(new Error('{/literal}{l s="Image URL is empty." mod="aiimageedit" js=1}{literal}'));
                return;
            }
            const img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = () => {
                const canvas = document.createElement('canvas');
                canvas.width = img.naturalWidth;
                canvas.height = img.naturalHeight;
                if (canvas.width === 0 || canvas.height === 0) {
                    reject(new Error('{/literal}{l s="Image has zero dimensions, cannot convert to base64." mod="aiimageedit" js=1}{literal}'));
                    return;
                }
                const ctx = canvas.getContext('2d');
                ctx.drawImage(img, 0, 0);
                try {
                    let base64String = canvas.toDataURL('image/jpeg'); // Default to jpeg
                    base64String = base64String.split(',')[1];
                    resolve(base64String);
                } catch (e) {
                    console.error('imageUrlToBase64Canvas: Canvas toDataURL error:', e);
                    reject(e);
                }
            };
            img.onerror = (e) => {
                console.error('imageUrlToBase64Canvas: Image onerror for URL:', url, 'Error:', e);
                $('#ai-gen-status-message').html('<div class="alert alert-danger">{/literal}{l s="Error loading base image for AI. Check console." mod="aiimageedit" js=1}{literal}</div>').show();
                reject(new Error('{/literal}{l s="Base image load error. Cannot proceed with AI." mod="aiimageedit" js=1}{literal}'));
            };
            img.src = url;
        });
    }

    function updatePosition1Display() {
        console.log("AIIMAGEEDIT: Updating Position 1. Base image:", currentBaseImage);
        const $previewEl = $('#ai-position-1-preview');
        const $infoEl = $('#ai-position-1-info');
        const $dimsEl = $('#ai-position-1-dimensions');

        if (currentBaseImage.displayUrl) {
            $previewEl.attr('src', currentBaseImage.displayUrl)
                      .attr('alt', currentBaseImage.legend || '{/literal}{l s="Base Image" mod="aiimageedit" js=1}{literal}')
                      .addClass('is-active-base') // Add class to highlight it
                      .show();
            
            let typeDisplay = '';
            if (currentBaseImage.type === 'original') {
                typeDisplay = '{/literal}{l s="Original Product Image" mod="aiimageedit" js=1}{literal}';
            } else if (currentBaseImage.type === 'generated') {
                typeDisplay = '{/literal}{l s="AI Generated Image" mod="aiimageedit" js=1}{literal}';
            } else if (currentBaseImage.type === 'upscaled') {
                typeDisplay = '{/literal}{l s="AI Upscaled Image" mod="aiimageedit" js=1}{literal}';
            } else {
                typeDisplay = '{/literal}{l s="Selected Base" mod="aiimageedit" js=1}{literal}';
            }
            $infoEl.text(typeDisplay + (currentBaseImage.legend ? ': ' + currentBaseImage.legend : ''));

            if (currentBaseImage.width && currentBaseImage.height) {
                $dimsEl.text(`${currentBaseImage.width}x${currentBaseImage.height} px`);
                $('#ai-generate-image-btn, #ai-upscale-image-btn').prop('disabled', false);

                // Update "Scale to original base dimensions" target display
                // This target is ALWAYS based on `initialOriginalForUpscaleTarget`
                if (initialOriginalForUpscaleTarget.width && initialOriginalForUpscaleTarget.height) {
                    $('#ai_upscale_target_dims_display').text(`${initialOriginalForUpscaleTarget.width}x${initialOriginalForUpscaleTarget.height} px`);
                } else {
                     $('#ai_upscale_target_dims_display').text('({/literal}{l s="Select original image first" mod="aiimageedit" js=1}{literal})');
                }
            } else {
                $dimsEl.text('({/literal}{l s="Loading dimensions..." mod="aiimageedit" js=1}{literal})');
                $('#ai-generate-image-btn, #ai-upscale-image-btn').prop('disabled', true);
            }
        } else {
            $previewEl.attr('src', '').removeClass('is-active-base').hide();
            $infoEl.text('{/literal}{l s="Click an image from the gallery or a result to set as base." mod="aiimageedit" js=1}{literal}');
            $dimsEl.text('');
            $('#ai_upscale_target_dims_display').text('({/literal}{l s="Select original image first" mod="aiimageedit" js=1}{literal})');
            $('#ai-generate-image-btn, #ai-upscale-image-btn').prop('disabled', true);
        }
    }


    function setBaseImageFromElement($element) {
        console.log("AIIMAGEEDIT: setBaseImageFromElement called for:", $element.attr('alt'));
        
		
        // Remove 'selected-source' from all gallery/result items
        $('.ai-gallery-selectable-image.selected-source').removeClass('selected-source');
        $('.ai-result-selectable-image.selected-source').removeClass('selected-source');
        // Add 'selected-source' to the clicked element
        $element.addClass('selected-source');

        currentBaseImage.id = $element.data('image-id') || null;
        currentBaseImage.internalId = $element.data('internal-id') || null;
        currentBaseImage.type = $element.data('type');
        currentBaseImage.url = $element.data('original-url') || $element.attr('src'); // Full URL for API
        currentBaseImage.displayUrl = $element.attr('src'); // Thumbnail/display URL for Position 1
        currentBaseImage.legend = $element.data('legend') || $element.attr('alt') || '';
		currentBaseImageLegend = currentBaseImage.legend; // Guardamos la leyenda en la variable global
		
        currentBaseImage.isAIResult = $element.hasClass('ai-result-selectable-image');
        currentBaseImage.width = null; currentBaseImage.height = null; // Reset
        updatePosition1Display(); // Initial update
		
		
        const widthFromData = $element.data('width');
        const heightFromData = $element.data('height');

        if (widthFromData && heightFromData) {
            currentBaseImage.width = parseInt(widthFromData);
            currentBaseImage.height = parseInt(heightFromData);
            // If this is an original image and its the first time an original is selected, set it for upscale target
            if (currentBaseImage.type === 'original' && !initialOriginalForUpscaleTarget.width) {
                initialOriginalForUpscaleTarget.id = currentBaseImage.id;
                initialOriginalForUpscaleTarget.width = currentBaseImage.width;
                initialOriginalForUpscaleTarget.height = currentBaseImage.height;
            }
            updatePosition1Display();
        } else {
            const tempImg = new Image();
            tempImg.onload = function() {
                currentBaseImage.width = this.naturalWidth;
                currentBaseImage.height = this.naturalHeight;
                if (currentBaseImage.type === 'original' && (!initialOriginalForUpscaleTarget.width || initialOriginalForUpscaleTarget.id === null)) {
                    initialOriginalForUpscaleTarget = { id: currentBaseImage.id, width: currentBaseImage.width, height: currentBaseImage.height };
                }
                updatePosition1Display();
            };
            tempImg.src = currentBaseImage.url;
        }
    }
	
	    // ----- DISPLAYING AI RESULTS -----
    function createResultCard(type, tempCardId, iterationText = '', aspectRatio = '1/1') {
        console.log("AIIMAGEEDIT: Creating result card for", type, tempCardId, iterationText);
		console.log("AIIMAGEEDIT: Creating result card for", type, "with aspect ratio:", aspectRatio);
        $('.if-empty-results').hide();

        var titleText = (type === 'generated' ? '{/literal}{l s="AI Gen." mod="aiimageedit" js=1}{literal}' : '{/literal}{l s="AI Upscale" mod="aiimageedit" js=1}{literal}') + (iterationText ? ' ' + iterationText : '');
		const imageElementId = `result-img-${tempCardId}`;
		let scaleButtonHtml = '';
		if (type === 'generated') {
			// --- AÑADIMOS data-target-img-id AL BOTÓN ---
			scaleButtonHtml = `
				<button type="button" class="btn btn-secondary btn-sm ai-scale-from-card-btn" 
						data-target-img-id="${imageElementId}"
						title="{/literal}{l s='Scale this image using the current upscale settings' mod='aiimageedit' js=1}{literal}'">
					<i class="material-icons" style="font-size:1em;">aspect_ratio</i> {/literal}{l s='Scale' mod="aiimageedit" js=1}{literal}
				</button>
			`;
		}

        const cardHtml = `
            <div class="col-md-3 col-sm-3 ai-result-card ai-image-item-wrapper" id="${tempCardId}" style="margin-bottom: 15px;">
                <div class="card h-100">
                    <div class="card-header text-muted small p-2">${titleText}</div>
                    <div class="ai-result-image-placeholder text-center" style="height: auto; aspect-ratio: ${aspectRatio}; display: flex; align-items: center; justify-content: center; background-color: #f8f9fa; border-bottom: 1px solid #eee;">
                        ${getSpinnerHtml('2.5rem')}
                    </div>
					<div class="ai-image-container">
                    <img src=""
					     id="${imageElementId}"
                         class="img-thumbnail ai-result-selectable-image"
                         data-internal-id="${tempCardId}"
                         data-type="${type}"
                         alt="${titleText}"
                         style="cursor:pointer; width:100%; height: auto; object-fit:contain; margin-bottom:5px; display:none;"
                         title="{/literal}{l s='Click to select or enlarge' mod="aiimageedit" js=1}{literal}">
						 <div class="ai-zoom-icon" data-gallery-type="result-gallery">
                            <i class="material-icons">zoom_in</i>
                        </div>
				    </div>
                    <p class="text-muted text-center small image-dimensions" style="margin-top: 2px; margin-bottom: 5px;"></p>
                    <div class="card-footer text-center p-2" style="display:none;">
                        <button class="btn btn-success btn-sm ai-save-result-btn"
                                data-image-url=""
                                data-output-format="png">
                            <i class="material-icons">save</i> {/literal}{l s='Save' mod="aiimageedit" js=1}{literal}
                        </button>
						 ${scaleButtonHtml} 
                    </div>
                </div>
            </div>
        `;
        $('#ai-results-area').append(cardHtml);
    }

    function updateResultCardSuccess(tempCardId, imageUrl, width, height, outputFormat = 'png') {
        console.log("AIIMAGEEDIT: Updating result card SUCCESS:", tempCardId, imageUrl);
        const $card = $('#' + tempCardId);
        $card.find('.ai-result-image-placeholder').hide();
        $card.find('img.ai-result-selectable-image')
            .attr('src', imageUrl)
            .data('original-url', imageUrl) // For consistency with original images
            .data('width', width)
            .data('height', height)
            .show();
        $card.find('.image-dimensions').text(`${width || '?'}x${height || '?'} px`);
        $card.find('.card-footer').show();
        $card.find('.ai-save-result-btn').data('image-url', imageUrl).data('output-format', outputFormat);
    }

    function updateResultCardError(tempCardId, errorMessage) {
        console.log("AIIMAGEEDIT: Updating result card ERROR:", tempCardId, errorMessage);
        const $card = $('#' + tempCardId);
        $card.find('.ai-result-image-placeholder').html(`<p class="text-danger small p-2">${errorMessage}</p>`).show();
        $card.find('img.ai-result-selectable-image').hide();
        $card.find('.card-footer').hide();
    }

    function updateButtonSpinner(buttonId, isLoading, originalHtml) {
        const $button = $('#' + buttonId);
        if (isLoading) {
            $button.data('original-html', $button.html()); // Store original HTML
            $button.prop('disabled', true).html('<i class="material-icons icon-spin-ai">hourglass_empty</i> {/literal}{l s="Processing..." mod="aiimageedit" js=1}{literal}');
        } else {
            $button.prop('disabled', false).html($button.data('original-html') || originalHtml); // Restore
        }
    }


    // ----- DOCUMENT READY -----
    $(document).ready(function() {
        console.log('AIIMAGEEDIT: Document ready. Initializing...');

        // Initial base image selection (Position 1)
        const $initiallySelectedSource = $('.ai-gallery-selectable-image.selected-source');
        if ($initiallySelectedSource.length > 0) {
            setBaseImageFromElement($initiallySelectedSource.first());
        } else {
             const $firstOriginalImg = $('#ai-original-image-gallery .ai-gallery-selectable-image:first');
            if ($firstOriginalImg.length > 0) {
                 setBaseImageFromElement($firstOriginalImg); // Auto-select first original if none explicitly marked
            } else {
                updatePosition1Display(); // Show "select image"
            }
        }


        // --- Event Handlers ---
        $('#ai-original-image-gallery').on('click', '.ai-gallery-selectable-image', function() {
            setBaseImageFromElement($(this));
        });
        $('#ai-results-area').on('click', '.ai-result-selectable-image', function() {
            setBaseImageFromElement($(this));
        });
		
        $('#ai_num_images').on('input', function() { $('#ai_num_images_value').text($(this).val()); });
        $('#ai_moderation_level').on('input', function() { $('#ai_moderation_level_value').text($(this).val()); });
        $('#ai_num_images, #ai_moderation_level').trigger('input'); // Initial display

        // Advanced settings toggles
        $('#advancedGenHeader').on('click', function() {
            $(this).find('.expand-icon-gen').text($('#advancedGenParamsContainer').hasClass('show') ? 'expand_more' : 'expand_less');
        });
        $('#manageConfigHeader').on('click', function() {
            $(this).find('.expand-icon-config').text($('#manageConfigContent').hasClass('show') ? 'expand_more' : 'expand_less');
        });
		
		// Llama a la función al cargar la página y cada vez que cambia la opción de radio
        handleCustomScaleInputVisibility();
        $('input[name="ai_upscale_mode_option"]').on('change', handleCustomScaleInputVisibility);


        $(document).on('click', '#insufficientCreditsBuyBtn', function() {
            var $btn = $(this);
            // Reutilizamos la lógica del botón de la página de configuración si la tienes,
            // o la implementamos aquí. Por simplicidad, la replicamos.
            $btn.prop('disabled', true).find('.material-icons').addClass('icon-spin-ai').text('hourglass_empty');

            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'getTopUpUrl', // La acción que ya tienes
					token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    if (response.success && response.checkout_url) {
                        window.open(response.checkout_url, '_blank'); // Redirigir a Stripe
                    } else {
                        alert(response.message || '{/literal}{l s="Could not get the payment link." mod="aiimageedit" js=1}{literal}');
                        $btn.prop('disabled', false).find('.material-icons').removeClass('icon-spin-ai').text('add_shopping_cart');
                    }
                },
                error: function() {
                    alert('{/literal}{l s="AJAX error. Could not connect to server." mod="aiimageedit" js=1}{literal}');
                    $btn.prop('disabled', false).find('.material-icons').removeClass('icon-spin-ai').text('add_shopping_cart');
                }
            });
        });

       function handleCustomScaleInputVisibility() {
            var selectedMode = $('input[name="ai_upscale_mode_option"]:checked').val();
            if (selectedMode === 'custom') {
                $('#ai_custom_scale_input_wrapper').show();
            } else {
                $('#ai_custom_scale_input_wrapper').hide();
            }
        }

        function updateAiConfigsDropdown(configsData) {
            var $dropdown = $('#ai_saved_configs_dropdown');
            var currentVal = $dropdown.val(); // Preserve selection if possible
            $dropdown.find('option:not(:first-child)').remove(); // Clear existing options except the placeholder

            if (configsData && configsData.length > 0) {
                $.each(configsData, function(i, config) {
                    $dropdown.append($('<option>', {
                        value: config.id_aiimageedit_config,
                        text: config.name
                    }));
                });
                if (currentVal) {
                    $dropdown.val(currentVal); // Try to re-select
                }
            }
        }

function getCurrentFormParams() {
    let seedVal = $('#ai_seed').val().trim();
    const selectedMode = $('input[name="ai_upscale_mode_option"]:checked').val();
    let isSpecific = (selectedMode === 'specific');
    
    // Si el modo es 'x2', nos aseguramos de que el factor que guardamos es 2.0.
    // Si es 'custom', guardamos el valor del campo de texto.
    // Si es 'specific', el valor del factor es menos importante, pero lo guardamos de todas formas.
    let factorValue = parseFloat($('#ai_custom_scale_value').val());
    if (selectedMode === 'x2') {
        factorValue = 2.0;
    }

    return {
        prompt: $('#ai_prompt').val().trim(),
        num_images: parseInt($('#ai_num_images').val()),
        moderation_level: parseInt($('#ai_moderation_level').val()),
        seed: seedVal ? seedVal : null,
        output_format: $('#ai_output_format').val(),
        model: $('#ai_model').val(),
        
		// --- CONVERSIÓN EXPLÍCITA A 1/0 ---
        prompt_upsampling: $('#ai_prompt_upsampling').is(':checked') ? 1 : 0,
        upscale_target_specific: ($('input[name="ai_upscale_mode_option"]:checked').val() === 'specific') ? 1 : 0,
        upscale_factor: parseFloat($('#ai_custom_scale_value').val()),
        upscale_face_enhance: $('#ai_upscale_face_enhance').is(':checked') ? 1 : 0,
    };
}

function applyParamsToForm(params) {
    // Aplicar valores a los campos de generación
    $('#ai_prompt').val(params.prompt || '');
    $('#ai_num_images').val(params.num_images || 1).trigger('input');
    $('#ai_moderation_level').val(params.moderation_level || 2).trigger('input');
    $('#ai_seed').val(params.seed || '');
    $('#ai_output_format').val(params.output_format || 'jpeg');
    $('#ai_model').val(params.model || 'Pro');
    $('#ai_prompt_upsampling').prop('checked', !!params.prompt_upsampling);

    // --- LÓGICA DE APLICACIÓN DE ESCALADO CORREGIDA ---

    // 1. Establecer el valor del campo de texto personalizado
    $('#ai_custom_scale_value').val(parseFloat(params.upscale_factor || 1.5).toFixed(6));
    
	if (params.upscale_target_specific) {
        $('#ai_upscale_to_specific').prop('checked', true);
    } else {
        // Si no es 'specific', puede ser 'x2' o 'custom'.
        // Comparamos el factor guardado para decidir.
        // Usamos una pequeña tolerancia (epsilon) para la comparación de flotantes.
        if (Math.abs(factorValue - 2.0) < 0.00001) {
            $('#ai_upscale_by_factor_2x').prop('checked', true);
        } else {
            $('#ai_upscale_by_custom').prop('checked', true);
        }
    }
	

    // 3. Establecer el checkbox de 'face_enhance'
    var faceEnhance = (params.upscale_face_enhance !== undefined) ? !!params.upscale_face_enhance : true;
    $('#ai_upscale_face_enhance').prop('checked', faceEnhance);

    // 4. Actualizar la visibilidad del campo de texto
    handleCustomScaleInputVisibility();
}

        // Load Selected Configuration
        $('#ai-load-config-btn').on('click', function() {
            var configId = $('#ai_saved_configs_dropdown').val();
            if (!configId) {
                alert('{/literal}{l s="Please select a configuration to load." mod="aiimageedit" js=1}{literal}');
                return;
            }
            $('#ai-config-message-area').html('').removeClass('alert-success alert-danger');

            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'loadAiConfig',
                    id_config: configId,
                    token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    if (response.success && response.config) {
                        applyParamsToForm(response.config);
                        $('#ai_new_config_name').val(response.config.name); // Pre-fill name for potential re-save
                        $('#ai-config-message-area').html('{/literal}{l s="Configuration loaded:" mod="aiimageedit" js=1}{literal} ' + response.config.name).addClass('alert alert-success').show();
                    } else {
                        $('#ai-config-message-area').html(response.message || '{/literal}{l s="Failed to load configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                    }
                },
                error: function() {
                    $('#ai-config-message-area').html('{/literal}{l s="AJAX error loading configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                }
            });
        });

        // Save Current Configuration (New or Update)
        $('#ai-save-config-btn').on('click', function() {
            var configName = $('#ai_new_config_name').val().trim();
            if (!configName) {
                alert('{/literal}{l s="Please enter a name for this configuration." mod="aiimageedit" js=1}{literal}');
                $('#ai_new_config_name').focus();
                return;
            }
            var paramsToSave = getCurrentFormParams();
            if (!paramsToSave.prompt && confirm('{/literal}{l s="The prompt is empty. Do you want to save this configuration without a prompt?" mod="aiimageedit" js=1}{literal}') === false) {
                $('#ai_prompt').focus();
                return;
            }

            $('#ai-config-message-area').html('').removeClass('alert-success alert-danger');
            var $button = $(this);
            var originalHtml = $button.html();
            updateButtonSpinner($button.attr('id'), true, originalHtml);


            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: Object.assign({}, paramsToSave, { // Merge params with AJAX requirements
                    ajax: 1,
                    action: 'saveAiConfig',
                    config_name: configName,
                    token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                }),
                success: function(response) {
                    if (response.success) {
                        $('#ai-config-message-area').html(response.message).addClass('alert alert-success').show();
                        // Refresh dropdown
                        $.ajax({
                            url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                            type: 'POST', data: { ajax: 1, action: 'getAiConfigs', token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}' },
                            dataType: 'json',
                            success: function(listResponse) {
                                if (listResponse.success) {
                                    updateAiConfigsDropdown(listResponse.configs);
                                    if (response.config_id) { // Try to select the newly saved/updated one
                                        $('#ai_saved_configs_dropdown').val(response.config_id);
                                    }
                                }
                            }
                        });
                    } else {
                        $('#ai-config-message-area').html(response.message || '{/literal}{l s="Failed to save configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                    }
                },
                error: function() {
                    $('#ai-config-message-area').html('{/literal}{l s="AJAX error saving configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                },
                complete: function() {
                    updateButtonSpinner($button.attr('id'), false, originalHtml);
                }
            });
        });

        // Delete Selected Configuration
        $('#ai-delete-config-btn').on('click', function() {
            var configId = $('#ai_saved_configs_dropdown').val();
            var configName = $('#ai_saved_configs_dropdown option:selected').text();
            if (!configId) {
                alert('{/literal}{l s="Please select a configuration to delete." mod="aiimageedit" js=1}{literal}');
                return;
            }
            if (!confirm('{/literal}{l s="Are you sure you want to delete configuration:" mod="aiimageedit" js=1}{literal} \'' + configName + '\'?')) {
                return;
            }
            $('#ai-config-message-area').html('').removeClass('alert-success alert-danger');
            var $button = $(this);
            var originalHtml = $button.html();
            updateButtonSpinner($button.attr('id'), true, originalHtml);


            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'deleteAiConfig',
                    id_config: configId,
                    token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    if (response.success) {
                        $('#ai-config-message-area').html(response.message).addClass('alert alert-success').show();
                        $('#ai_new_config_name').val(''); // Clear name field if it matched deleted
                        $('#ai_saved_configs_dropdown option[value="' + configId + '"]').remove();
                        $('#ai_saved_configs_dropdown').val(''); // Reset dropdown selection
                    } else {
                        $('#ai-config-message-area').html(response.message || '{/literal}{l s="Failed to delete configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                    }
                },
                error: function() {
                    $('#ai-config-message-area').html('{/literal}{l s="AJAX error deleting configuration." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                },
                complete: function() {
                    updateButtonSpinner($button.attr('id'), false, originalHtml);
                }
            });
        });

        // Set as Default button
        $('#ai-save-default-btn').on('click', function() {
            console.log('AIIMAGEEDIT: Set as Default button clicked.');
            var $button = $(this);
            var originalButtonHtml = $button.html();
            updateButtonSpinner($button.attr('id'), true, originalButtonHtml);
            $('#ai-config-message-area').html('').removeClass('alert-success alert-danger');

            var paramsToSaveAsDefault = getCurrentFormParams(); // Get all current UI values

            console.log("AIIMAGEEDIT: Params to save as default:", paramsToSaveAsDefault);

            $.ajax({
                url: "{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}",
                type: 'POST',
                dataType: 'json',
                data: Object.assign({}, paramsToSaveAsDefault, {
                    ajax: 1,
                    action: 'saveDefaultAiParams',
                    token: "{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}"
                }),
                success: function(response) {
                    if (response.success) {
                        $('#ai-config-message-area').html(response.message).addClass('alert alert-success').show();
                        // Optionally update the ai_default_params JS variable if you use it for resets
                        // ai_default_params = paramsToSaveAsDefault; // (Requires ai_default_params to be global)
                    } else {
                        $('#ai-config-message-area').html(response.message || '{/literal}{l s="Failed to save default settings." mod="aiimageedit" js=1}{literal}').addClass('alert alert-danger').show();
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    $('#ai-config-message-area').html('{/literal}{l s="AJAX error saving default settings:" mod="aiimageedit" js=1}{literal} ' + errorThrown).addClass('alert alert-danger').show();
                },
                complete: function() {
                    updateButtonSpinner($button.attr('id'), false, originalButtonHtml);
                }
            });
        });
        // ----- END AI CONFIGURATION MANAGEMENT -----     

        // ----- AI GENERATION (BFL) -----
        $('#ai-generate-image-btn').on('click', async function() {
            if (!currentBaseImage.url) {
                alert('{/literal}{l s="Please select a base image for Position 1 first." mod="aiimageedit" js=1}{literal}');
                return;
            }
            const promptText = $('#ai_prompt').val().trim();
            if (!promptText) {
                alert('{/literal}{l s="Prompt is mandatory for AI Generation." mod="aiimageedit" js=1}{literal}');
                $('#ai_prompt').focus();
                return;
            }
            if (!BFL_API_KEY) {
                $('#ai-gen-status-message').html('{/literal}{l s="BFL API Key not configured." mod="aiimageedit" js=1}{literal}').addClass('alert-danger').show();
                return;
            }

            var $generateBtn = $(this);
            updateButtonState($generateBtn, true, '{/literal}<i class="material-icons">auto_awesome</i> {l s="Generate AI Images" mod="aiimageedit" js=1}{literal}');
            $('#ai-gen-status-message').html('{/literal}{l s="Preparing base image..." mod="aiimageedit" js=1}{literal}').removeClass('alert-danger alert-success').addClass('alert-info').show();
            
            

            try {
			    const base64InputImage = await getBase64ForCurrentImage();
                
                const numImagesToGenerate = parseInt($('#ai_num_images').val());
                let requestsMade = 0;
            
			    const baseAspectRatio = (currentBaseImage.width && currentBaseImage.height) ? `${currentBaseImage.width}/${currentBaseImage.height}` : '1/1';
                for (let i = 0; i < numImagesToGenerate; i++) {
                    const tempCardId = 'gen-result-' + Date.now() + '-' + i;
                    createResultCard('generated', tempCardId, (i + 1).toString(), baseAspectRatio);

                    const payload = {
                        ajax: 1,
                        action: 'createAiRequest',
                        token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}',
                        prompt: promptText,
                        input_image_base64: base64InputImage,
                        moderation_level: parseInt($('#ai_moderation_level').val()),
                        output_format: $('#ai_output_format').val(),
                        prompt_upsampling: $('#ai_prompt_upsampling').is(':checked')? 1:0,
						model: $('#ai_model').val(),
                    };
                    const seedVal = $('#ai_seed').val().trim();
                    if (seedVal) { payload.seed = seedVal + i; } // Vary seed for multiple images

                     $.ajax({
                        url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                        type: 'POST',
                        dataType: 'json',
                        data: payload
                    }).done(function(response) { // Usamos .done() que es similar a success
                        if (response.success && response.request_id) {
                            // --- Caso de Éxito: La tarea se envió ---
                            activePolls++;
                            console.log(`AIIMAGEEDIT: Request ${i+1} submitted. ID: ${response.request_id}`);
                            
                            aiGenPollingData[tempCardId] = { bflRequestId: response.request_id, iteration: i };
                            const initialPollDelay = 1000; // Un retraso más corto es suficiente
                            
                            setTimeout(function() {
                                pollBflResult(tempCardId, response.request_id, $generateBtn);
                            }, initialPollDelay);

                        } else {
                            // --- Caso de Fallo Controlado por el Servidor (incluyendo "insufficient credits") ---
                            const errorMessage = response.message || '{/literal}{l s="Submission failed" mod="aiimageedit" js=1}{literal}';
                            updateResultCardError(tempCardId, errorMessage);

                            // Comprobamos si el fallo es por falta de créditos
                            if (response.message && response.message.toLowerCase().includes('insufficient credits')) {
                                showInsufficientCreditsAction(); // Mostramos el botón de acción
                            }
                        }
                    }).fail(function() {
                        // --- Caso de Fallo de AJAX (error de red, 500, etc.) ---
                        console.error('AJAX Error creating BFL request for iteration ' + i);
                        updateResultCardError(tempCardId, '{/literal}{l s="AJAX submission error" mod="aiimageedit" js=1}{literal}');
                    }).always(function() {
                        // --- Se ejecuta siempre, con éxito o fallo ---
                        requestsMade++;
                        // Comprobamos si todas las solicitudes iniciales han terminado
                        if (requestsMade === numImagesToGenerate) {
                            console.log("AIIMAGEEDIT: All submission attempts are complete.");
                            // Si no hay sondeos activos, significa que todas fallaron al crearse,
                            // por lo que podemos resetear el botón.
                            if (activePolls === 0) {
                                updateButtonState($generateBtn, false);
                                showStatusMessage('danger', '{/literal}{l s="All generation requests failed to start." mod="aiimageedit" js=1}{literal}', 5000);
                            }
                        }
                    });
                } // End for loop
                 if (numImagesToGenerate === 0) updateButtonState($generateBtn, false); // Should not happen with range 1-4

            } catch (error) {
                console.error('Error during BFL image generation prep:', error);
                $('#ai-gen-status-message').html(error.message || '{/literal}{l s="Error preparing image for BFL." mod="aiimageedit" js=1}{literal}').addClass('alert-danger');
                updateButtonState($generateBtn, false);
            }
        });
		
	    // --- NUEVO: Manejador de eventos para el botón "Scale" en las tarjetas de resultado ---
$('#ai-results-area').on('click', '.ai-scale-from-card-btn', function(e) {
            e.preventDefault();
            e.stopPropagation();

            console.log("AIIMAGEEDIT: 'Scale from card' button clicked.");

            // 1. Obtiene el ID de la imagen del data-attribute del botón
            var targetImageId = $(this).data('target-img-id');
            console.log("AIIMAGEEDIT: Looking for image with ID selector: #" + targetImageId);
            
            // 2. Selecciona la imagen directamente por su ID
            var $imageToSelect = $('#' + targetImageId);
            
            if ($imageToSelect.length > 0) {
                // Éxito: Se encontró la imagen
                console.log("AIIMAGEEDIT: Image found successfully. Proceeding to set as base.");

                // Llama a la función para establecer la imagen base
                setBaseImageFromElement($imageToSelect);
                console.log("AIIMAGEEDIT: New base image set. Now triggering main scale button.");


                // Dispara un clic en el botón principal "Scale with AI"
                setTimeout(function() {
                    $('#ai-upscale-image-btn').trigger('click');
                }, 100);

            } else {
                // Error: No se encontró la imagen. Esto indica un problema en createResultCard.
                console.error("AIIMAGEEDIT: CRITICAL - Could not find the image with ID selector: #" + targetImageId + ". Check the HTML generated by createResultCard.");
                alert('{/literal}{l s="An internal error occurred: could not find the target image for scaling." mod="aiimageedit" js=1}{literal}');
            }
        });
		
        // ----- AI UPSCALING (REPLICATE) -----
        $('#ai-upscale-image-btn').on('click', async function() {
            if (!currentBaseImage.url) {
                alert('{/literal}{l s="Please select a base image first." mod="aiimageedit" js=1}{literal}');
                return;
            }
            if (!currentBaseImage.width || !currentBaseImage.height) {
                alert('{/literal}{l s="Base image dimensions are not available. Cannot calculate scale." mod="aiimageedit" js=1}{literal}');
                return;
            }

            var $upscaleBtn = $(this);
            updateButtonState($upscaleBtn, true, '{/literal}<i class="material-icons">aspect_ratio</i> {l s="Scale with AI" mod="aiimageedit" js=1}{literal}');
            $('#ai-upscale-status-message').html('{/literal}{l s="Preparing for upscale..." mod="aiimageedit" js=1}{literal}').removeClass('alert-danger alert-success').addClass('alert-info').show();
           

            let scaleFactor;
            const upscaleMode = $('input[name="ai_upscale_mode_option"]:checked').val();

            if (upscaleMode === 'factor_2x') {
                scaleFactor = 2.0;
			} else if (upscaleMode === 'custom') {
                scaleFactor = parseFloat($('#ai_custom_scale_value').val());
                if (isNaN(scaleFactor) || scaleFactor <= 0) {
                    alert('{/literal}{l s="Please enter a valid positive number for custom scale." mod="aiimageedit" js=1}{literal}');
                    updateButtonState($upscaleBtn, false); return;
                }
            } else { // 'specific'
                if (!initialOriginalForUpscaleTarget.width) {
                    alert('{/literal}{l s="Target dimensions (from initial original image) not set for specific scaling." mod="aiimageedit" js=1}{literal}');
                    updateButtonState($upscaleBtn, false);
                    return;
                }
                // Calculate scale factor to reach target width, Replicate handles aspect ratio.
                scaleFactor = parseFloat((initialOriginalForUpscaleTarget.width / currentBaseImage.width));
                if (scaleFactor <= 0.1 || scaleFactor > 8) { // Replicate might have limits (e.g. 1x to 8x for some models)
                    alert('{/literal}{l s="Calculated scale factor (" mod="aiimageedit" js=1}{literal}' + scaleFactor + '{/literal}{l s=") is out of typical bounds (e.g., 0.1-8). Adjusting to a safe value or check logic." mod="aiimageedit" js=1}{literal}');
                    // You might clamp it or prevent the call. For now, let's proceed if user confirms.
                    if (!confirm('{/literal}{l s="Calculated scale factor is" mod="aiimageedit" js=1}{literal} ' + scaleFactor + '{/literal}{l s=". Continue?" mod="aiimageedit" js=1}{literal}')) {
                        updateButtonState($upscaleBtn, false); return;
                    }
                }
                 if (scaleFactor < 0.1) scaleFactor = 0.1; // Min clamp
                 if (scaleFactor > 8) scaleFactor = 8;   // Max clamp based on common Replicate limits
            }

            const tempCardId = 'upscale-result-' + Date.now();
		    const baseAspectRatio = (currentBaseImage.width && currentBaseImage.height) ? `${currentBaseImage.width}/${currentBaseImage.height}` : '1/1';
            createResultCard('upscaled', tempCardId,baseAspectRatio);
			var faceEnhanceValue = $('#ai_upscale_face_enhance').is(':checked') ? 1:0;
			
            const payload = {
                ajax: 1, action: 'createUpscaleRequest',
                token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}',
                image_url: currentBaseImage.url, // Send the direct URL for Replicate
                scale_factor: scaleFactor,
                face_enhance:  faceEnhanceValue,
            };

            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: payload,
                success: function(response) {
                    // --- NUEVA LÓGICA DE DETECCIÓN DE ERROR DE CRÉDITOS ---
                    if (response.success === false && response.message && response.message.toLowerCase().includes('insufficient credits')) {
                        // La creación de la tarea falló por falta de créditos.
                        
                        // 1. Muestra el error en el área de estado de upscale.
                        showStatusMessage('danger', response.message, 0, 'upscale');
                        
                        // 2. Muestra un mensaje de error en la tarjeta de resultado que se creó.
                        updateResultCardError(tempCardId, '{/literal}{l s="Not enough credits" mod="aiimageedit" js=1}{literal}');
                        
                        // 3. Llama a la función que muestra el botón de acción (Subscribe/Buy).
                        showInsufficientCreditsAction();
                        
                        // 4. Restaura el estado del botón principal de "Scale with AI".
                        updateButtonState($upscaleBtn, false);
                        
                        return; // Detenemos la ejecución aquí, no hay nada que sondear.
                    }
                    // --- FIN DE LA NUEVA LÓGICA ---

                    // Si no hubo error de créditos, continuamos con la lógica original.
                    if (response.success && response.request_id) {
                        showStatusMessage('info', '{/literal}{l s="Upscale request submitted. Polling for result..." mod="aiimageedit" js=1}{literal}', 0, 'upscale');
                        aiUpscalePollingData[tempCardId] = { replicateRequestId: response.request_id };
                        pollReplicateResult(tempCardId, $upscaleBtn);
                    } else {
                        updateResultCardError(tempCardId, response.message || '{/literal}{l s="Failed to submit Replicate request." mod="aiimageedit" js=1}{literal}');
                        updateButtonState($upscaleBtn, false);
                    }
                },
                error: function() {
                    updateResultCardError(tempCardId, '{/literal}{l s="AJAX error for Replicate request." mod="aiimageedit" js=1}{literal}');
                    updateButtonState($upscaleBtn, false);
                }
            });
        });


        function pollReplicateResult(tempCardId, $upscaleBtn) {
            const pollData = aiUpscalePollingData[tempCardId];
            if (!pollData) return;

            let attempts = 0;
            const maxAttempts = 90; // Replicate can take longer (e.g. ~4.5 mins max)

            pollData.intervalId = setInterval(function() {
                attempts++;
                if (attempts > maxAttempts) {
                    clearInterval(pollData.intervalId);
                    updateResultCardError(tempCardId, '{/literal}{l s="Replicate polling timed out." mod="aiimageedit" js=1}{literal}');
                    updateButtonState($upscaleBtn, false);
                    return;
                }

                $.ajax({
                    url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        ajax: 1, action: 'pollUpscaleResult',
                        request_id: pollData.replicateRequestId,
                        token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                    },
                    success: function(response) {
                        const $statusPlaceholder = $('#' + tempCardId).find('.ai-result-image-placeholder');
                        $statusPlaceholder.html(`{/literal}{l s="Upscale Status:" mod="aiimageedit" js=1}{literal} ${response.status || 'Polling...'} <br/> <small>${response.logs || ''}</small>`);

                        if (response.status === "succeeded") {
                            clearInterval(pollData.intervalId);
                            if (response.success && response.image_url) {
							    $('#ai-upscale-status-message').append('<br/>{/literal}{l s="Upscale finished." mod="aiimageedit" js=1}{literal}');
                                setTimeout(function(){ $('#ai-upscale-status-message').fadeOut(); }, 1000);
							
                                const tempResultImg = new Image();
                                tempResultImg.onload = function() {
                                    updateResultCardSuccess(tempCardId, response.image_url, this.naturalWidth, this.naturalHeight, 'png'); // Replicate often outputs PNG
                                };
                                tempResultImg.onerror = function() {
                                     updateResultCardSuccess(tempCardId, response.image_url, null, null, 'png');
                                };
                                tempResultImg.src = response.image_url;
                            } else {
                                updateResultCardError(tempCardId, response.message || '{/literal}{l s="Replicate succeeded, but no image URL." mod="aiimageedit" js=1}{literal}');
                            }
                            updateButtonState($upscaleBtn, false);
                        } else if (response.status === "failed" || response.status === "canceled") {
                            clearInterval(pollData.intervalId);
                            updateResultCardError(tempCardId, response.message || '{/literal}{l s="Replicate error:" mod="aiimageedit" js=1}{literal} ' + response.status);
                            updateButtonState($upscaleBtn, false);
                        }
                    },
                    error: function() {
                        clearInterval(pollData.intervalId);
                        updateResultCardError(tempCardId, '{/literal}{l s="AJAX error polling Replicate." mod="aiimageedit" js=1}{literal}');
                        updateButtonState($upscaleBtn, false);
                    }
                });
            }, 2000); // Poll Replicate a bit less frequently
        }


	
	    // ----- PAN & ZOOM LOGIC -----
    // Revised function to initialize the zoom/pan state
   function applyTransform() {
        const tx = panZoomState.translateX;
        const ty = panZoomState.translateY;
        $('#aiEnlargedImageSrc').css('transform', `translate(${tx}px, ${ty}px) scale(${panZoomState.scale})`);
    }

    /**
     * Corrected Reset Function:
     * Sets the initial state to exactly what you requested: scale 1, position 0,0.
     * It then immediately calls checkBoundaries() which will correctly center the image
     * ONLY if it's smaller than the container, otherwise it leaves it at 0,0.
     */
    function resetPanZoomState(imgWidth, imgHeight) {
        // Set the state to the users desired initial position.
        panZoomState.scale = 1.0;
        panZoomState.translateX = 0;
        panZoomState.translateY = 0;

        // Set other state variables.
        panZoomState.isPannable = false;
        panZoomState.isPanning = false;
        panZoomState.start = { x: 0, y: 0 };
        panZoomState.imageNaturalWidth = imgWidth;
        panZoomState.imageNaturalHeight = imgHeight;
        
        // Check boundaries from this initial state.
        checkBoundaries();
        applyTransform();
    }

    function checkBoundaries() {
        const container = $('#aiPanZoomContainer');
        const containerWidth = container.width();
        const containerHeight = container.height();
        const scaledWidth = panZoomState.imageNaturalWidth * panZoomState.scale;
        const scaledHeight = panZoomState.imageNaturalHeight * panZoomState.scale;

        let { translateX, translateY } = panZoomState;

        // HORIZONTAL BOUNDS:
        // If the scaled image is narrower than the container, it should be centered.
        // if (scaledWidth <= containerWidth) {
        //    translateX = (containerWidth - scaledWidth) / 2;
        // } 
        // If it's wider (pannable), clamp its edges to the container's edges.
        // else {
        //    if (translateX > 0) translateX = 0; // Clamp left edge
        //    const minTranslateX = containerWidth - scaledWidth;
        //    if (translateX < minTranslateX) translateX = minTranslateX; // Clamp right edge
        // }

        // VERTICAL BOUNDS:
        // If the scaled image is shorter than the container, it should be centered.
       // if (scaledHeight <= containerHeight) {
       //     translateY = (containerHeight - scaledHeight) / 2;
       // } 
        // If it's taller (pannable), clamp its edges.
      //  else {
      //      if (translateY > 0) translateY = 0; // Clamp top edge
      //      const minTranslateY = containerHeight - scaledHeight;
      //      if (translateY < minTranslateY) translateY = minTranslateY; // Clamp bottom edge
      //  }

        // Apply the corrected values back to the state
        panZoomState.translateX = translateX;
        panZoomState.translateY = translateY;
        panZoomState.isPannable = scaledWidth > containerWidth || scaledHeight > containerHeight;
    }


    function doZoom(zoomIn = true) {
        const scaleFactor = 1.2;
        const maxScale = 8.0;
        const oldScale = panZoomState.scale;
        let newScale = zoomIn ? oldScale * scaleFactor : oldScale / scaleFactor;
        
        // Set a minimum scale of 1, as requested by the initial state.
        newScale = Math.max(1.0, Math.min(maxScale, newScale));

        // The formula for transform-origin: top left
        // panZoomState.translateX = mouse.x - (mouse.x - panZoomState.translateX) * (newScale / oldScale);
        // panZoomState.translateY = mouse.y - (mouse.y - panZoomState.translateY) * (newScale / oldScale);
        panZoomState.scale = newScale;

        checkBoundaries();
        applyTransform();
    }



    // ----- MODAL LOGIC (REVISED FOR PAN/ZOOM) -----
    function openImageModal(clickedElement, gallerySelector) {
        console.log("AIIMAGEEDIT: openImageModal called.");
        modalGallery = [];
        var clickedImageSrc = $(clickedElement).data('original-url') || $(clickedElement).attr('src');
        var galleryIsAiResults = (gallerySelector.indexOf('#ai-results-area') > -1);

        $('.ai-zoom-control').show();
        $('#aiModalCompareIcon').toggle(galleryIsAiResults && !!currentBaseImage.url);

        $(gallerySelector).each(function(index) {
            var $thumb = $(this);
            var fullUrl = $thumb.data('original-url') || $thumb.attr('src');
            modalGallery.push({
                src: fullUrl,
                title: $thumb.data('legend') || $thumb.attr('alt') || '{/literal}{l s="Image" mod="aiimageedit" js=1}{literal}'
            });
            if (fullUrl === clickedImageSrc) {
                modalCurrentIndex = index;
            }
        });

        if (modalGallery.length > 0) {
            updateModalView(); // This will now handle preloading
            $('#aiImageEnlargeModal').modal('show');
        } else {
            console.warn("AIIMAGEEDIT: Could not build gallery for zoom.");
        }
    }

	
    function updateModalView() {
        if (modalGallery.length === 0 || modalCurrentIndex < 0 || modalCurrentIndex >= modalGallery.length) {
            $('#aiImageEnlargeModal').modal('hide');
            return;
        }
        
        var imageData = modalGallery[modalCurrentIndex];
        originalZoomedImageSrc = imageData.src; // Store for compare feature

        var $enlargedImg = $('#aiEnlargedImageSrc');
        var $panZoomContainer = $('#aiPanZoomContainer');

        // Hide the image and show a spinner inside the container while it loads
        $enlargedImg.hide();
        $panZoomContainer.css('cursor', 'wait').html(getSpinnerHtml('3rem'));

        // Preload the image to get its dimensions before showing it
        var tempImg = new Image();
        tempImg.onload = function() {
            // Now that the image is loaded, we have correct dimensions
            console.log(`AIIMAGEEDIT: Modal image loaded. Natural Dims: ${this.naturalWidth}x${this.naturalHeight}`);

            // Put the image back into the container and set its src
            $panZoomContainer.html('').append($enlargedImg);
            $enlargedImg.attr('src', imageData.src);
            
            // Reset the pan/zoom state with the correct dimensions
            resetPanZoomState(this.naturalWidth, this.naturalHeight);
            
            // Now, show the image and restore cursor
            $enlargedImg.show();
            $panZoomContainer.css('cursor', 'grab');
        };
        tempImg.onerror = function() {
            console.error("AIIMAGEEDIT: Failed to load enlarged image for modal:", imageData.src);
            $panZoomContainer.html('<p class="text-danger">{/literal}{l s="Error: Could not load image." mod="aiimageedit" js=1}{literal}</p>');
            $panZoomContainer.css('cursor', 'default');
        }
        
        // This triggers the download
        tempImg.src = imageData.src;
        
        $('#aiImageEnlargeModalLabel').text(imageData.title);
        $('#aiModalPrevImage').toggle(modalCurrentIndex > 0);
        $('#aiModalNextImage').toggle(modalCurrentIndex < modalGallery.length - 1);
    }
	

        function pollBflResult(tempCardId) {
            const pollData = aiGenPollingData[tempCardId];
            if (!pollData) return;

            let attempts = 0;
            const maxAttempts = 70; // Approx 4 minutes (70 * 3.5s)
			
			let notFoundRetries = 0;
            const maxNotFoundRetries = 5; 
			
            // --- ESTADO INICIAL DENTRO DE LA TARJETA ---
            const $statusPlaceholder = $('#' + tempCardId).find('.ai-result-image-placeholder');
            $statusPlaceholder.html('{/literal}{l s="Waiting in queue..." mod="aiimageedit" js=1}{literal}')
			
            pollData.intervalId = setInterval(function() {
                attempts++;
                if (attempts > maxAttempts) {
                    clearInterval(pollData.intervalId);
					activePolls--;
                    updateResultCardError(tempCardId, '{/literal}{l s="Polling timed out." mod="aiimageedit" js=1}{literal}');
                    checkAllBflPollsDone();
                    return;
                }

                $.ajax({
                    url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        ajax: 1, action: 'pollAiResult',
                        request_id: pollData.bflRequestId,
                        token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                    },
success: function(response) {
                        const $statusPlaceholder = $('#' + tempCardId).find('.ai-result-image-placeholder');

                        // --- NUEVA LÓGICA DE REINTENTOS PARA "TASK NOT FOUND" ---
                        if (response.success === false && response.status === 'Task not found') {
                            notFoundRetries++;
                            console.warn(`AIIMAGEEDIT: "Task not found" for ID ${pollData.bflRequestId}. Retry attempt ${notFoundRetries}/${maxNotFoundRetries}.`);
                            $statusPlaceholder.html(`{/literal}{l s="Locating task..." mod="aiimageedit" js=1}{literal} (${notFoundRetries})`);
                            
                            if (notFoundRetries >= maxNotFoundRetries) {
                                // Se superó el límite de reintentos, ahora sí es un error definitivo.
                                clearInterval(pollData.intervalId);
                                activePolls--;
                                updateResultCardError(tempCardId, '{/literal}{l s="Task not found." mod="aiimageedit" js=1}{literal}');
                                checkAllBflPollsDone();
                            }
                            // Si no se supera el límite, no hacemos nada y dejamos que el siguiente intervalo lo intente de nuevo.
                            return; // IMPORTANTE: Salir de la función success aquí para no procesar más.
                        }
                        // --- FIN DE LA NUEVA LÓGICA DE REINTENTOS ---

                        // Si llegamos aquí, reseteamos el contador de reintentos 404 porque encontramos la tarea.
                        notFoundRetries = 0; 
                        
                        // Lógica original que ya tenías
                        let statusText = response.status || '{/literal}{l s="Polling..." mod="aiimageedit" js=1}{literal}';
						if (response.progress) {
                            statusText = `{/literal}{l s="Processing" mod="aiimageedit" js=1}{literal}... ${(response.progress * 100).toFixed(0)}%`;
                        }
						$statusPlaceholder.html(statusText);
						
                        if (response.status === "Ready") {
                            clearInterval(pollData.intervalId);
                            activePolls--;
                            if (response.success && response.image_url) {
                                // Fetch dimensions for the new image
                                const tempResultImg = new Image();
                                tempResultImg.onload = function() {
                                    updateResultCardSuccess(tempCardId, response.image_url, this.naturalWidth, this.naturalHeight, $('#ai_output_format').val());
                                };
                                tempResultImg.onerror = function() {
                                    updateResultCardSuccess(tempCardId, response.image_url, null, null, $('#ai_output_format').val());
                                };
                                tempResultImg.src = response.image_url;
                            } else {
                                updateResultCardError(tempCardId, response.message || '{/literal}{l s="Ready, but no image URL." mod="aiimageedit" js=1}{literal}');
                            }
                            checkAllBflPollsDone();
                        } else if (response.status !== "Processing" && response.status !== "Queued" && response.status !== "Pending") {
                            clearInterval(pollData.intervalId);
                            activePolls--;
                            updateResultCardError(tempCardId, response.message || '{/literal}{l s="Error:" mod="aiimageedit" js=1}{literal} ' + response.status);
                            checkAllBflPollsDone();
                        }
                    },
                    error: function() {
                        clearInterval(pollData.intervalId);
						activePolls--;
                        updateResultCardError(tempCardId, '{/literal}{l s="AJAX error polling image." mod="aiimageedit" js=1}{literal}');
                        checkAllBflPollsDone();
                    }
                });
            }, 3000);
        }

        function checkAllBflPollsDone() {
		    console.log("Check if all polls done");
            if (activePolls <= 0) {
                console.log("AIIMAGEEDIT: All polls finished.");
                activePolls = 0; // Reset just in case
                updateButtonState($('#ai-generate-image-btn'), false);
				$('#generation-message').hide();
				$('#generate-ai-image-btn').find('.spinner-border').hide();
                $('#ai-gen-status-message').append('<br/>{/literal}{l s="All generation attempts finished." mod="aiimageedit" js=1}{literal}');
                 setTimeout(function(){ $('#ai-gen-status-message').fadeOut(); }, 1000);
            }
        }



        // ----- DISPLAYING RESULTS -----
    function displayAiResult(imageData, type = 'generated') {
        console.log("AIIMAGEEDIT: Displaying result:", imageData, "Type:", type);
        $('.if-empty-results').hide(); // Hide "No results yet" message

        const internalId = type + '-' + Date.now() + Math.random().toString(16).slice(2);
        const dimensionsText = (imageData.width && imageData.height) ? `${imageData.width}x${imageData.height} px` : '{/literal}{l s="Dimensions N/A" mod="aiimageedit" js=1}{literal}';
        // Create a meaningful legend/alt text for the new image
        const legendText = `${type.charAt(0).toUpperCase() + type.slice(1)}: ${currentBaseImage.legend || '{/literal}{l s="Variation" mod="aiimageedit" js=1}{literal}'}`;

        const cardHtml = `
            <div class="col-md-2 col-sm-4 ai-result-card-item" id="card-${internalId}">
                <div class="card h-100">
                    
                    {* --- THIS IS THE NEW PART FOR THE IMAGE AND ZOOM ICON --- *}
                    <div class="ai-image-container">
                        <img src="${imageData.url}"
                             class="img-thumbnail ai-result-selectable-image"
                             data-original-url="${imageData.url}"
                             data-internal-id="${internalId}"
                             data-type="${type}"
                             data-width="${imageData.width || ''}"
                             data-height="${imageData.height || ''}"
                             data-legend="${legendText.replace(/"/g, '"')}"
                             alt="${legendText.replace(/"/g, '"')}"
                             style="cursor:pointer; width:100%; height:auto; max-height: 150px; object-fit:contain;"
                             title="{/literal}{l s='Click to select or enlarge' mod='aiimageedit' js=1}{literal}">
                        
                        <div class="ai-zoom-icon" data-gallery-type="result-gallery">
                            <i class="material-icons">zoom_in</i>
                        </div>
                    </div>
                    {* --- END OF NEW PART --- *}

                    <div class="card-body p-2 text-center">
                        <p class="text-muted text-center small image-dimensions" style="margin-bottom:5px;">${dimensionsText}</p>
                        <button class="btn btn-success btn-sm ai-save-result-btn" 
                                data-image-url="${imageData.url}" 
                                data-output-format="png">
                            <i class="material-icons" style="font-size:1em;">save</i> {/literal}{l s='Save' mod="aiimageedit" js=1}{literal}
                        </button>
                    </div>
                </div>
            </div>
        `;
        $('#ai-results-area').append(cardHtml);
    }
        // ----- SAVING A RESULT IMAGE -----
        $('#ai-results-area').on('click', '.ai-save-result-btn', function() {
            var $button = $(this);
            var imageUrl = $button.data('image-url');
            var outputFormat = $button.data('output-format'); // Pass this to controller
            var originalButtonHtml = $button.html();

            console.log("AIIMAGEEDIT: Save result button clicked for URL:", imageUrl);
            updateButtonSpinner($button.attr('id'), true); // This wont work as button has no ID, use $button directly

            $button.prop('disabled', true).html('<i class="material-icons icon-spin-ai">hourglass_empty</i> {/literal}{l s="Saving..." mod="aiimageedit" js=1}{literal}');

            $.ajax({
                url: '{/literal}{$ai_controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'saveAiGeneratedImage', // Your controller action
                    id_product: {/literal}{$ai_id_product|intval}{literal},
                    generated_image_url: imageUrl,
                    output_format: outputFormat,
					legend: currentBaseImageLegend,
                    legend_base: currentBaseImage.legend || '', // Pass base legend
                    token: '{/literal}{$ai_ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    if (response.success && response.new_image_data) {
                        $button.removeClass('btn-success').addClass('btn-light').html('<i class="material-icons">check_circle</i> {/literal}{l s="Saved!" mod="aiimageedit" js=1}{literal}');
                        showSuccessMessage(response.message || '{/literal}{l s="Image saved successfully!" mod="aiimageedit" js=1}{literal}');
						addOriginalImageToGallery(response.new_image_data);

                        // Optionally, refresh original image list or add to it dynamically
                    } else {
                        $button.prop('disabled', false).html(originalButtonHtml);
                        showErrorMessage(response.message || '{/literal}{l s="Failed to save image." mod="aiimageedit" js=1}{literal}');
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    $button.prop('disabled', false).html(originalButtonHtml);
                    showErrorMessage('{/literal}{l s="AJAX error while saving:" mod="aiimageedit" js=1}{literal} ' + errorThrown);
                }
            });
        });

	$('#ai-position-1-preview').on('click', function() {
            if (currentBaseImage.url) {
                enlargedImageGallery = [{ src: currentBaseImage.url, title: currentBaseImage.legend || '{/literal}{l s="Current Base Image" mod="aiimageedit" js=1}{literal}' }];
                currentEnlargedImageIndex = 0;
                isModalForOriginals = (currentBaseImage.type === 'original'); // Or more complex logic
                updateModalEnlargedContent(); // Your existing modal display function
            }
        });

        // ----- CONFIGURATION MANAGEMENT JS -----
        // (Your existing load, save, delete, set default config JS logic)
        // Ensure all {l s='...'} are wrapped.
        // Example for getCurrentAiParams:
        function getCurrentAiParamsAndUpscale() {
            let seedVal = $('#ai_seed').val().trim();
            return {
                prompt: $('#ai_prompt').val().trim(),
                num_images: parseInt($('#ai_num_images').val()),
                moderation_level: parseInt($('#ai_moderation_level').val()),
                seed: seedVal || null, // Send null if empty for easier DB handling
                output_format: $('#ai_output_format').val(),
                prompt_upsampling: $('#ai_prompt_upsampling').is(':checked'),
                upscale_target_specific: $('input[name="ai_upscale_mode_option"]:checked').val() === 'specific',
                upscale_factor: 2.0, // Will be overridden if specific is chosen and dims are calculated
                upscale_face_enhance: $('#ai_upscale_face_enhance').is(':checked')
            };
        }
        // Update your config save/load to use this function and handle all fields.


        // --- Refresh & Go Back Button ---


        // --- Enlarge Image Modal Logic ---
        function setupModalGallery(clickedElementIsOriginal, $clickedElement) {
            enlargedImageGallery = [];
            isModalForOriginals = clickedElementIsOriginal;

            if (isModalForOriginals) {
                // Populate from all original product images
                $('#ai-image-list .ai-selectable-image:visible').each(function(index) {
                    var $thumb = $(this);
                    enlargedImageGallery.push({
                        src: $thumb.data('original-url'),
                        title: $thumb.attr('alt') || '{/literal}{l s="Product Image" mod="aiimageedit" js=1}{literal} ' + (index + 1)
                    });
                    if ($thumb.is($clickedElement)) {
                        currentEnlargedImageIndex = index;
                    }
                });
            } else { // Generated/Upscaled result image
                 // Populate from all generated/upscaled images in the results area
                $('#ai-results-area .ai-result-selectable-image:visible').each(function(index) {
                    var $thumb = $(this);
                    enlargedImageGallery.push({
                        src: $thumb.data('original-url'), // This is the full URL of the result
                        title: $thumb.attr('alt') || '{/literal}{l s="AI Result" mod="aiimageedit" js=1}{literal} ' + (index + 1)
                    });
                     if ($thumb.is($clickedElement)) {
                        currentEnlargedImageIndex = index;
                    }
                });
            }

            if (enlargedImageGallery.length > 0) {
                updateModalEnlargedContent();
            } else {
                 $('#aiImageEnlargeModal').modal('hide');
            }
        }

    function updateModalEnlargedContent() {
        if (enlargedImageGallery.length === 0 || currentEnlargedImageIndex < 0 || currentEnlargedImageIndex >= enlargedImageGallery.length) {
            console.error("AIIMAGEEDIT: Modal update error - invalid index or gallery.");
            $('#aiImageEnlargeModal').modal('hide');
            return;
        }
        var imageData = enlargedImageGallery[currentEnlargedImageIndex];
        $('#aiEnlargedImageSrc').attr('src', imageData.src);
        $('#aiImageEnlargeModalLabel').text(imageData.title);
        $('#aiModalPrevImage').toggle(currentEnlargedImageIndex > 0);
        $('#aiModalNextImage').toggle(currentEnlargedImageIndex < enlargedImageGallery.length - 1);
        $('#aiImageEnlargeModal').modal('show');
    }
    
        // This single handler will manage clicks from all image areas.
        // --- NEW UNIFIED DELEGATED EVENT HANDLER FOR ALL ZOOM ICONS ---
        $(document).on('click', '.ai-zoom-icon', function(e) {
            e.stopPropagation(); // Prevent click from bubbling up to the image selection handler
            
			
			var $image = $(this).siblings('img'); // Get the image next to the icon
            var galleryType = $(this).data('gallery-type');

            console.log("AIIMAGEEDIT: Zoom icon clicked. Gallery Type:", galleryType);

            // Show zoom controls for all types except Position 1s non-gallery view
            $('.ai-zoom-control').show();
            
            // Logic to show hide compare button
            const isAiResult = (galleryType === 'result-gallery');
            $('#aiModalCompareIcon').toggle(isAiResult && !!currentBaseImage.url);
            
            if (galleryType === 'original-gallery') {
                // User wants to see the gallery of original product images
                openImageModal($image, '#ai-original-image-gallery .ai-gallery-selectable-image:visible');
            } else if (galleryType === 'result-gallery') {
                // *** THIS IS THE CRITICAL PART FOR AI RESULTS ***
                // User wants to see the gallery of generated/upscaled images
				openImageModal($image, '#ai-results-area .ai-result-selectable-image:visible');
            } else if (galleryType === 'position-1') {
                // User wants to zoom in on the single image in Position 1
                if (currentBaseImage.url) {
                    $('#aiModalCompareIcon').hide(); // No compare for the base image itself
                    
                    // A single image gallery means prev/next buttons will be hidden by updateModalView
                    modalGallery = [{
                        src: currentBaseImage.url,
                        title: currentBaseImage.legend || '{/literal}{l s="Current Base Image" mod="aiimageedit" js=1}{literal}'
                    }];
                    modalCurrentIndex = 0;
                    
                    updateModalView();
                    $('#aiImageEnlargeModal').modal('show');
                }
            }
        });


        // ZOOM IN/OUT BUTTONS
   // ZOOM IN/OUT BUTTONS
    $('#aiModalZoomIn').on('click', function() {
        const container = $('#aiPanZoomContainer');
        mouse.x = container.width() / 2;
        mouse.y = container.height() / 2;
        doZoom(true);
    });

    $('#aiModalZoomOut').on('click', function() {
        const container = $('#aiPanZoomContainer');
        mouse.x = container.width() / 2;
        mouse.y = container.height() / 2;
        doZoom(false);
    });

    // MOUSE WHEEL ZOOM
    $('#aiPanZoomContainer').on('wheel', function(e) {
        e.preventDefault();
        doZoom(e.originalEvent.deltaY < 0);
    });

    // PAN (DRAG) LOGIC
    const panContainer = document.getElementById('aiPanZoomContainer');

    panContainer.addEventListener('mousemove', function(e) {
        const rect = panContainer.getBoundingClientRect();
        mouse.x = e.clientX - rect.left;
        mouse.y = e.clientY - rect.top;
    });

    panContainer.addEventListener('mousedown', function(e) {
        if (!panZoomState.isPannable) return;
        e.preventDefault();
        panZoomState.isPanning = true;
        panContainer.classList.add('grabbing');
        panZoomState.start.x = e.clientX - panZoomState.translateX;
        panZoomState.start.y = e.clientY - panZoomState.translateY;
    });

    window.addEventListener('mousemove', function(e) {
        if (!panZoomState.isPanning) return;
        e.preventDefault();
        panZoomState.translateX = e.clientX - panZoomState.start.x;
        panZoomState.translateY = e.clientY - panZoomState.start.y;
        checkBoundaries();
        applyTransform();
    });

    window.addEventListener('mouseup', function(e) {
        if (panZoomState.isPanning) {
            panZoomState.isPanning = false;
            panContainer.classList.remove('grabbing');
        }
    });

		
        // Click on original product image from the list for modal
        $('#ai-image-list').on('click', '.ai-selectable-image', function(e) {
            // This function is ALREADY selecting the image as base.
            // If the click target is the image itself, and its already selected, then open modal.
            if ($(e.target).is('img') && $(this).hasClass('selected') && currentBaseImage.url === $(this).data('original-url')) {
                 console.log("AIIMAGEEDIT: Clicked selected original image for zoom.");
                 setupModalGallery(true, $(this));
            }
        });
        
        // Click on a result image for modal
        $('#ai-results-area').on('click', '.ai-result-selectable-image', function(e) {
             if ($(e.target).is('img') && $(this).hasClass('selected') && currentBaseImage.url === $(this).data('original-url')) {
                console.log("AIIMAGEEDIT: Clicked selected result image for zoom.");
                setupModalGallery(false, $(this));
             }
        });


        // ----- MODAL NAVIGATION HANDLERS -----
        $('#aiModalPrevImage').on('click', function() {
            if (modalCurrentIndex > 0) {
                modalCurrentIndex--;
                updateModalView();
            }
        });

        $('#aiModalNextImage').on('click', function() {
            if (modalCurrentIndex < modalGallery.length - 1) {
                modalCurrentIndex++;
                updateModalView();
            }
        });


        // COMPARE ICON EVENT HANDLERS (Hold & Release)
        // We use mousedown/mouseup for mouse and touchstart/touchend for mobile devices.
        $('#aiModalCompareIcon').on('mousedown touchstart', function(e) {
            e.preventDefault();
            if (currentBaseImage.url) {
                // When comparing, we show the base image using the CURRENT pan/zoom state
                // of the AI image. This makes the transition seamless.
                $('#aiEnlargedImageSrc').attr('src', currentBaseImage.url);
            }
        });

        $('#aiModalCompareIcon').on('mouseup touchend mouseleave', function(e) {
            e.preventDefault();
            if (originalZoomedImageSrc) {
                $('#aiEnlargedImageSrc').attr('src', originalZoomedImageSrc); // Revert to the AI image
            }
        });
		
        // Keyboard navigation for the modal
        $(document).on('keydown', function(e) {
            if ($('#aiImageEnlargeModal').is(':visible')) { // Only act if modal is open
                if (e.key === "ArrowLeft") {
                    e.preventDefault(); // Prevent browser from scrolling
                    $('#aiModalPrevImage').click();
                } else if (e.key === "ArrowRight") {
                    e.preventDefault();
                    $('#aiModalNextImage').click();
                } else if (e.key === "Escape") {
                    $('#aiImageEnlargeModal').modal('hide');
                }
            }
        });

        // Reset gallery when modal is closed to prevent state issues
        $('#aiImageEnlargeModal').on('shown.bs.modal', function() {
            const imgEl = document.getElementById('aiEnlargedImageSrc');
            
            // This logic is important to wait for the image to load
            const setupInitialState = () => {
                resetPanZoomState(imgEl.naturalWidth, imgEl.naturalHeight);
            };

            if (imgEl.complete && imgEl.naturalWidth > 0) {
                setupInitialState();
            } else {
                imgEl.onload = setupInitialState;
            }
        });
        
        // When modal is hidden, reset state
        $('#aiImageEnlargeModal').on('hidden.bs.modal', function () {
            modalGallery = [];
            modalCurrentIndex = 0;
            originalZoomedImageSrc = '';
            $('#aiEnlargedImageSrc').attr('src', '').css('transform', 'none'); // Full reset
            $('.ai-zoom-control, #aiModalCompareIcon').hide(); // Hide all controls on close
        });

    }); // End of $(document).ready()

{/literal}
</script>