<div class="panel">
    <h3><i class="icon icon-key"></i> {l s='AI Syncrasy Account & API Key' mod='aiimageedit'}        <a href="https://aisyncrasy.com/ps_aiimageedit_help?lang={$prestashop_lang_iso|escape:'html':'UTF-8'}" style="margin-left:2.5rem;" target="_blank" class="btn btn-default">
            <i class="material-icons" style="vertical-align:middle">help_outline</i> {l s='Help' mod='aiimageedit'}
        </a></h3>

        {if $api_key}
        {* --- ESTRUCTURA DE FORMULARIO CORREGIDA --- *}
        <div class="form-horizontal">
            {* API Key Display *}
            <div class="form-group">
                <label class="control-label col-lg-3">{l s='Your API Key' mod='aiimageedit'}</label>
                <div class="col-lg-7">
                    {* Usamos input-group para poner el botón al lado del campo de texto *}
                    <div class="input-group">
                        <input type="text" id="api_key_display" class="form-control" value="{$api_key|escape:'html':'UTF-8'}" readonly style="font-family: monospace; font-size: 1.1em;">
                        <span class="input-group-btn">
                            <button class="btn btn-default" type="button" id="editApiKeyBtn" title="{l s='Edit'}">
                                <i class="material-icons"  style="vertical-align: middle;">edit</i>{l s='Change' mod='aiimageedit'}
                            </button>
                        </span>
                    </div>
                    <p class="help-block">{l s="This is your API key, don't share it with anyone. Edit only if you have purchased a subscription elsewhere." mod='aiimageedit'}</p>
                </div>
            </div>

               {* --- NUEVO: Mostrar Email para usuarios Freemium --- *}
                {if $account_details.plan == 'freemium'}
                <div class="form-group">
                    <label class="control-label col-lg-3">{l s='Account Email' mod='aiimageedit'}</label>
                    <div class="col-lg-7">
                        <div class="input-group">
                            <input type="text" id="account_email_display" class="form-control" value="{$account_details.email|escape:'html':'UTF-8'}" readonly>
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button" id="changeEmailBtn" title="{l s='Change Email'}">
                                    <i class="material-icons" style="vertical-align: middle;" >email</i> {l s='Change' mod='aiimageedit'}
                                </button>
                            </span>
                        </div>
					   <p class="help-block">{l s="We have associated the API key with your shop's admin email... make sure to change it if you want before subscribing" mod='aiimageedit'}</p>
                    </div>
                </div>
                {/if}
                {* --- FIN --- *}
            {* Account Details Display *}
            {if isset($account_details) && !isset($account_details.error)}
 <div class="form-group">
                    <label class="control-label col-lg-3">{l s='Current Plan' mod='aiimageedit'}</label>
                    <div class="col-lg-9">
                        {* Usamos un div con el padding de un form-control para una alineación vertical perfecta *}
                        <div style="padding-top: 7px;">
                            <strong>{$account_details.plan|escape:'html':'UTF-8'|ucfirst}</strong>
                        </div>
                    </div>
                </div>
 <div class="form-group">
                    <label class="control-label col-lg-3">{l s='Credits Remaining' mod='aiimageedit'}</label>
                    <div class="col-lg-9">
                        <div style="padding-top: 7px;">
                            <strong>{$account_details.credits_remaining|intval}</strong>
                        </div>
                    </div>
                </div>

                {* Action Buttons *}
                <div class="form-group">
                    <label class="control-label col-lg-3">{l s='Actions' mod='aiimageedit'}</label>
                    <div class="col-lg-9">
                        {if $account_details.plan == 'freemium'}
                            <a href="https://aisyncrasy.com/ps_subscribe?user_id={$account_details.id|intval}&lang={$prestashop_lang_iso|escape:'html':'UTF-8'}#{$api_key|escape:'html':'UTF-8'}"
                               target="_blank" class="btn btn-lg {if $account_details.credits_remaining < 5}btn-primary{else}btn-primary{/if}">
                                <i class="material-icons">star</i> {l s='Subscribe to a Plan' mod='aiimageedit'}
                            </a>
                            {if $account_details.credits_remaining < 5}<p class="help-block text-warning" style="font-weight: bold;">{l s='Your credits are low!' mod='aiimageedit'}</p>{/if}
                        {else}
                            <button type="button" id="buyMoreCreditsBtn" class="btn btn-success">
                                <i class="material-icons">add_shopping_cart</i> {l s='Buy More Credits' mod='aiimageedit'}
                            </button>
                            <button type="button" id="manageSubscriptionBtn" class="btn btn-secondary" style="margin-left: 10px;">
                                <i class="material-icons">settings</i> {l s='Manage Subscription' mod='aiimageedit'}
                            </button>
                        {/if}
                    </div>
                </div>
            {elseif isset($account_details.error)}
                 <div class="form-group">
                    <div class="col-lg-9 col-lg-offset-3">
                         <div class="alert alert-danger">
                            <p>{$account_details.error|escape:'html':'UTF-8'}</p>
                        </div>
                    </div>
                 </div>
            {/if}
		        {else}
            {* Esto se muestra si NO TENEMOS una API key *}
            
            <div class="form-group">
                <label class="control-label col-lg-3">{l s='Your API Key' mod='aiimageedit'}</label>
                <div class="col-lg-7">
                    <div class="alert alert-warning">
                        {l s='An API Key is required to use the AI features. The automatic registration failed.' mod='aiimageedit'}
                        {if $registration_error}<br/><strong>{l s='Reason:' mod='aiimageedit'}</strong> {$registration_error|escape:'html':'UTF-8'}{/if}
                    </div>
                    <p class="help-block">{l s='Click the button to get a new API key and start your freemium plan, or use the "Edit" button if you already have a key.' mod='aiimageedit'}</p>
                </div>
            </div>
            
            <div class="form-group">
                <label class="control-label col-lg-3">{l s='Actions' mod='aiimageedit'}</label>
                <div class="col-lg-7">
                    <button type="button" id="getApiKeyBtn" class="btn btn-primary" >
                        <i class="material-icons" style="width:2.5rem;">vpn_key</i> {l s='Get API Key' mod='aiimageedit'}
                    </button>
                     <button class="btn btn-default" type="button" id="editApiKeyBtn2" title="{l s='Edit'}" style="margin-left:10px;">
                        <i class="material-icons" style="vertical-align:middle;">edit</i> {l s='Enter existing key' mod='aiimageedit'}
                    </button>
                </div>
            </div>

        {/if}
		    {* --- NUEVO: Panel de Ayuda en el Pie del Panel --- *}
    <div class="panel-footer">
        <p>
            <strong>
                {l s='To use the module, go to: Catalog > Products > [Select a Product] > Modules Tab > AI Image Edit' mod='aiimageedit'}
            </strong>
        </p>
    </div>
        </div>
        {* --- FIN DE LA ESTRUCTURA DE FORMULARIO CORREGIDA --- *}
</div>


{* JavaScript remains unchanged *}
<script>
{literal}
    $(document).ready(function() {
        
        // ----- LÓGICA DE POLLING AUTOMÁTICO -----

        var accountPollingInterval = null;
        var isPollingActive = true;
        
        // Valores iniciales mostrados en la página para comparar
		var initialPlan = '{/literal}{if isset($account_details) && isset($account_details.plan)}{$account_details.plan|escape:'javascript':'UTF-8'}{else}{/if}{literal}';
        var initialCredits = '{/literal}{if isset($account_details) && isset($account_details.credits_remaining)}{$account_details.credits_remaining|intval}{else}0{/if}{literal}';
        
        function startAccountPolling() {
            // Solo empieza a hacer polling si hay una API key y no hay errores
            if ('{/literal}{$api_key}{literal}' && !'{/literal}{$registration_error}{literal}') {
                console.log('AIIMAGEEDIT: Starting account status polling.');
                isPollingActive = true;
                
                accountPollingInterval = setInterval(function() {
                    if (!isPollingActive) {
                        console.log('AIIMAGEEDIT: Polling is paused. Skipping check.');
                        return;
                    }
                    
                    console.log('AIIMAGEEDIT: Polling for account status update...');

                    $.ajax({
                        url: '{/literal}{$controller_url|escape:'javascript':'UTF-8'}{literal}',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            ajax: 1,
                            action: 'getAccountStatus', // La nueva acción del controlador
                            token: '{/literal}{$ajax_token|escape:'javascript':'UTF-8'}{literal}'
                        },
                        success: function(response) {
                            if (response.success && response.account_details) {
                                var newPlan = response.account_details.plan;
                                var newCredits = response.account_details.credits_remaining;
                                
                                // Comparamos los datos nuevos con los que se cargaron inicialmente
                                if (newPlan !== initialPlan || newCredits.toString() !== initialCredits) {
                                    console.log('AIIMAGEEDIT: Account change detected! Reloading page.');
                                    isPollingActive = false; // Detener el polling
                                    clearInterval(accountPollingInterval);
                                    
                                    // Muestra un mensaje y recarga
                                    showSuccessMessage('{/literal}{l s="Account status updated! Reloading..." mod="aiimageedit" js=1}{literal}');
                                    setTimeout(function() {
                                        window.location.reload();
                                    }, 1500);
                                } else {
                                    console.log('AIIMAGEEDIT: No change in account status.');
                                }
                            } else {
                                console.warn('AIIMAGEEDIT: Poll request failed or returned no data.');
                            }
                        },
                        error: function() {
                            console.error('AIIMAGEEDIT: AJAX error during polling.');
                            // Podríamos detener el polling si hay errores de red repetidos, pero por ahora lo dejamos seguir.
                        }
                    });

                }, 7000); // Hacemos polling cada 7 segundos para no sobrecargar la API
            }
        }

        function stopAccountPolling() {
            if (accountPollingInterval) {
                console.log('AIIMAGEEDIT: Stopping account status polling.');
                clearInterval(accountPollingInterval);
                isPollingActive = false;
            }
        }

        // Iniciar el polling cuando la página carga
        startAccountPolling();

        // ----- MANEJADORES DE EVENTOS DE BOTONES -----
        $('#getApiKeyBtn').on('click', function() {
            var userEmail = prompt('{/literal}{l s="Please enter your email address to register and receive your API Key." mod="aiimageedit" js=1}{literal}');

            if (userEmail && userEmail.trim() !== '') {
                var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(userEmail)) {
                    alert('{/literal}{l s="The email address is not valid." mod="aiimageedit" js=1}{literal}');
                    return;
                }

                var $btn = $(this);
                var originalHtml = $btn.html();
                $btn.prop('disabled', true).html('<i class="material-icons icon-spin-ai">hourglass_empty</i> {/literal}{l s="Registering..." mod="aiimageedit" js=1}{literal}');

                // Llamada AJAX al nuevo método del controlador
                $.ajax({
                    url: '{/literal}{$controller_url|escape:'javascript':'UTF-8'}{literal}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        ajax: 1,
                        action: 'registerUser',
                        email: userEmail.trim(),
                        token: '{/literal}{$ajax_token|escape:'javascript':'UTF-8'}{literal}'
                    },
                    success: function(response) {
                        if (response.success) {
                            // Éxito: La API key se guardó. Mostramos el mensaje y recargamos.
                            alert('{/literal}{l s="Registration successful! Review your mailbox to confirm your email. Check your spam folder if you don\'t receive it. The page will now reload to show your account details." mod="aiimageedit" js=1}{literal}');
                            window.location.reload();
                        } else {
                            // Error de la API: mostramos el mensaje de error que nos da el controlador.
                            alert('{/literal}{l s="Registration Error:" mod="aiimageedit" js=1}{literal} ' + (response.message || '{/literal}{l s="An unknown error occurred." mod="aiimageedit" js=1}{literal}'));
                            $btn.prop('disabled', false).html(originalHtml);
                        }
                    },
                    error: function() {
                        // Error de conexión AJAX
                        alert('{/literal}{l s="AJAX error. Could not connect to the server." mod="aiimageedit" js=1}{literal}');
                        $btn.prop('disabled', false).html(originalHtml);
                    }
                });
            }
            // Si el usuario cancela el prompt, no hacemos nada.
        });
        $('#editApiKeyBtn').on('click', function() {
            // --- DETENER EL POLLING ANTES DE MOSTRAR EL PROMPT ---
            stopAccountPolling();

            var currentApiKey = $('#api_key_display').val();
            var newApiKey = prompt('{/literal}{l s="Enter your new API Key:" mod="aiimageedit" js=1}{literal}', currentApiKey);

            if (newApiKey && newApiKey.trim() !== '' && newApiKey.trim() !== currentApiKey.trim()) {
                var configureUrl = '{/literal}{$module_configure_url|escape:'javascript':'UTF-8'}{literal}';
                var redirectUrl = configureUrl;
                redirectUrl += '&submitUpdateApiKey=1';
                redirectUrl += '&manual_api_key=' + encodeURIComponent(newApiKey.trim());
                window.location.href = redirectUrl;
            } else if (newApiKey === null) {
                 // Si el usuario cancela, reanudamos el polling
                 startAccountPolling();
            }
        });
        $('#editApiKeyBtn2').on('click', function() {
            // --- DETENER EL POLLING ANTES DE MOSTRAR EL PROMPT ---
            stopAccountPolling();

            var currentApiKey = $('#api_key_display').val();
            var newApiKey = prompt('{/literal}{l s="Enter your API Key:" mod="aiimageedit" js=1}{literal}', currentApiKey);

            if (newApiKey && newApiKey.trim() !== '' && newApiKey.trim() !== currentApiKey.trim()) {
                var configureUrl = '{/literal}{$module_configure_url|escape:'javascript':'UTF-8'}{literal}';
                var redirectUrl = configureUrl;
                redirectUrl += '&submitUpdateApiKey=1';
                redirectUrl += '&manual_api_key=' + encodeURIComponent(newApiKey.trim());
                window.location.href = redirectUrl;
            } else if (newApiKey === null) {
                 // Si el usuario cancela, reanudamos el polling
                 startAccountPolling();
            }
        });
        // --- NUEVO: Manejador para el botón "Change Email" ---
        $('#changeEmailBtn').on('click', function() {
            var currentEmail = $('#account_email_display').val();
            var newEmail = prompt('{/literal}{l s="Enter your new email address:" mod="aiimageedit" js=1}{literal}', currentEmail);

            // Validar el email en el lado del cliente (una primera comprobación)
            if (newEmail && newEmail.trim() !== '' && newEmail.trim() !== currentEmail.trim()) {
                var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(newEmail)) {
                    alert('{/literal}{l s="Please enter a valid email address." mod="aiimageedit" js=1}{literal}');
                    return;
                }

                var $btn = $(this);
                var originalHtml = $btn.html();
                $btn.prop('disabled', true).html('<i class="material-icons icon-spin-ai">hourglass_empty</i>');

                // Llamada AJAX al nuevo método del controlador
                $.ajax({
                    url: '{/literal}{$controller_url|escape:'javascript':'UTF-8'}{literal}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        ajax: 1,
                        action: 'changeEmail',
                        newEmail: newEmail.trim(),
                        token: '{/literal}{$ajax_token|escape:'javascript':'UTF-8'}{literal}'
                    },
                    success: function(response) {
                        if (response.success) {
                            // Actualizar el campo de texto con el nuevo email
                            $('#account_email_display').val(response.newEmail);
                            showSuccessMessage(response.message); // Notificación global de PrestaShop
                        } else {
                            showErrorMessage(response.message || '{/literal}{l s="Failed to update email." mod="aiimageedit" js=1}{literal}');
                        }
                    },
                    error: function() {
                        showErrorMessage('{/literal}{l s="AJAX error. Could not connect to server." mod="aiimageedit" js=1}{literal}');
                    },
                    complete: function() {
                        $btn.prop('disabled', false).html(originalHtml);
                    }
                });

            } else if (newEmail !== null) {
                // El usuario hizo clic en OK pero no cambió nada o lo dejó vacío
                // No hacemos nada.
            }
        });

        $('#buyMoreCreditsBtn').on('click', function() {
            var $btn = $(this);
            var originalIcon = $btn.find('.material-icons').text();
            
            // Deshabilitar y mostrar spinner
            $btn.prop('disabled', true).find('.material-icons').addClass('icon-spin-ai').text('hourglass_empty');

            // Llamada AJAX al nuevo método del controlador
            $.ajax({
                url: '{/literal}{$controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'getTopUpUrl', // La acción que creaste en el controlador
                    token: '{/literal}{$ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    // La respuesta del controlador para este método debe ser 'checkout_url', no 'portal_url'
                    if (response.success && response.checkout_url) {
                        // Si todo va bien, redirigimos a la URL de Stripe
						 window.open(response.checkout_url, '_blank');
                    } else {
                        // Si hay un error, lo mostramos en una alerta
                        alert(response.message || '{/literal}{l s="Could not get the payment link!" mod="aiimageedit" js=1}{literal}');
                        // Restauramos el botón solo en caso de error
                        $btn.prop('disabled', false).find('.material-icons').removeClass('icon-spin-ai').text(originalIcon);
                    }
                },
                error: function() {
                    // Error de conexión AJAX
                    alert('{/literal}{l s="AJAX error. Could not connect to the server." mod="aiimageedit" js=1}{literal}');
                    // Restauramos el botón en caso de error
                    $btn.prop('disabled', false).find('.material-icons').removeClass('icon-spin-ai').text(originalIcon);
                }
                // No hay 'complete' aquí porque si tiene éxito, la página redirige y no es necesario restaurar el botón.
            });
        });

        $('#manageSubscriptionBtn').on('click', function() {
            var $btn = $(this);
            var originalIcon = $btn.find('.material-icons').text();
            
            $btn.prop('disabled', true).find('.material-icons').addClass('icon-spin-ai').text('hourglass_empty');

            $.ajax({
                url: '{/literal}{$controller_url|escape:'javascript':'UTF-8'}{literal}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'getSubscriptionPortalUrl',
                    token: '{/literal}{$ajax_token|escape:'javascript':'UTF-8'}{literal}'
                },
                success: function(response) {
                    if (response.success && response.portal_url) {
                        window.open(response.portal_url, '_blank');
                    } else {
                        alert(response.message || '{/literal}{l s="Could not get the subscription portal URL." mod="aiimageedit" js=1}{literal}');
                    }
                },
                error: function() {
                    alert('{/literal}{l s="AJAX error. Could not connect to the server." mod="aiimageedit" js=1}{literal}');
                },
                complete: function() {
                     $btn.prop('disabled', false).find('.material-icons').removeClass('icon-spin-ai').text(originalIcon);
                }
            });
        });


        // Detener el polling si el usuario abandona la página
        $(window).on('beforeunload', function() {
            stopAccountPolling();
        });

    });
{/literal}
</script>