// views/js/admin_product.js

$(document).ready(function() {
        $('#manage-config-content').on('show.bs.collapse', function () {
        $('#expand-icon').text('expand_less');
    });

    $('#manage-config-content').on('hide.bs.collapse', function () {
        $('#expand-icon').text('expand_more');
    });
});
    // Add AI Image Edit tab to the product form
    if ($('#product-tab-content-images').length) {
        // Create the tab
        var aiImageTab = '<li>' +
            '<a href="#ai-image-edit" data-toggle="tab">' +
            '<i class="icon-magic"></i> AI Image Edit' +
            '</a>' +
            '</li>';
        
        // Find the images tab and add our tab after it
        $('.nav-tabs li').each(function() {
            if ($(this).find('a[href="#product-tab-content-images"]').length) {
                $(this).after(aiImageTab);
                return false;
            }
        });
        
        // Move the AI Image Edit panel to a tab content area
        if ($('#ai-image-edit-panel').length) {
            var panelContent = $('#ai-image-edit-panel').html();
            var tabContent = '<div id="ai-image-edit" class="tab-pane">' +
                '<div class="panel panel-default">' +
                panelContent +
                '</div>' +
                '</div>';
            
            // Add tab content after images tab content
            $('#product-tab-content-images').after(tabContent);
            
            // Remove original panel
            $('#ai-image-edit-panel').remove();
        }
    }
    
    // Enhanced image selection and details functionality
    function updateImageDetails(imageElement) {
        var imageId = imageElement.data('id-image');
        var img = imageElement.find('img');
        
        // Show loading state
        $('#image-details').html('<div class="text-center"><i class="icon-spinner icon-spin"></i> Loading image details...</div>');
        
        // Create temporary image to get actual dimensions
        var tempImg = new Image();
        tempImg.onload = function() {
            var width = this.naturalWidth;
            var height = this.naturalHeight;
            var aspectRatio = (width / height).toFixed(2);
            
            // Calculate file size if possible
            getImageFileSize(img.attr('src'), function(fileSize) {
                var detailsHtml = buildImageDetailsHtml(imageId, width, height, aspectRatio, fileSize, img.attr('src'));
                $('#image-details').html(detailsHtml);
                $('#image-actions').fadeIn();
            });
        };
        
        tempImg.onerror = function() {
            $('#image-details').html('<div class="alert alert-warning">Could not load image details</div>');
        };
        
        tempImg.src = img.attr('src').replace('small_default', 'large_default');
    }
    


    function buildImageDetailsHtml(imageId, width, height, aspectRatio, fileSize, imageSrc) {
        return '<div class="image-details-content">' +
            '<h5><i class="icon-info-circle"></i> Image Information</h5>' +
            '<div class="row">' +
            '<div class="col-sm-6">' +
            '<p><strong>Image ID:</strong> <span class="label label-default">' + imageId + '</span></p>' +
            '<p><strong>Dimensions:</strong> ' + width + ' × ' + height + ' pixels</p>' +
            '<p><strong>Aspect Ratio:</strong> ' + aspectRatio + ':1</p>' +
            '<p><strong>File Size:</strong> ' + fileSize + ' KB</p>' +
            '</div>' +
            '<div class="col-sm-6">' +
            '<div class="selected-image-preview">' +
            '<img src="' + imageSrc.replace('small_default', 'medium_default') + '" class="img-responsive" style="max-width: 150px;">' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>';
    }
    
    function getImageFileSize(url, callback) {
        // Try to get file size via HEAD request
        $.ajax({
            type: 'HEAD',
            url: url.replace('small_default', 'large_default'),
            success: function(data, textStatus, xhr) {
                var size = xhr.getResponseHeader('Content-Length');
                if (size) {
                    callback(Math.round(size / 1024));
                } else {
                    callback('N/A');
                }
            },
            error: function() {
                callback('N/A');
            }
        });
    }
    
    // Copy image functionality with progress feedback
    function copySelectedImage(imageId, productId) {
        if (!imageId) {
            showNotification('Please select an image first', 'warning');
            return;
        }
        
        var $btn = $('#copy-image-btn');
        var originalText = $btn.html();
        
        // Show loading state
        $btn.prop('disabled', true).html('<i class="icon-spinner icon-spin"></i> Copying image...');
        
        $.ajax({
            url: window.location.href,
            type: 'POST',
            data: {
                ajax: 1,
                action: 'copyImage',
                id_image: imageId,
                id_product: productId
            },
            dataType: 'json',
            timeout: 30000,
            success: function(response) {
                if (response.success) {
                    showNotification('Image copied successfully! New image ID: ' + response.new_image_id, 'success');
                    // Optionally refresh the images list
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showNotification('Error: ' + response.message, 'danger');
                }
            },
            error: function(xhr, status, error) {
                if (status === 'timeout') {
                    showNotification('Request timed out. Please try again.', 'warning');
                } else {
                    showNotification('An error occurred while copying the image', 'danger');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).html(originalText);
            }
        });
    }
    
    function showNotification(message, type) {
        var alertClass = 'alert-' + type;
        var notification = '<div class="alert ' + alertClass + ' alert-dismissible" role="alert">' +
            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">' +
            '<span aria-hidden="true">&times;</span>' +
            '</button>' +
            message +
            '</div>';
        
        // Remove existing notifications
        $('.alert').remove();
        
        // Add new notification at the top of the panel
        $('#ai-image-edit .panel-body').prepend(notification);
        
        // Auto-hide after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    }
    
    // Event handlers
    $(document).on('click', '.image-item', function() {
        $('.image-item').removeClass('selected');
        $(this).addClass('selected');
        updateImageDetails($(this));
    });
    
    $(document).on('click', '#copy-image-btn', function() {
        var selectedImageId = $('.image-item.selected').data('id-image');
        var productId = $('.image-item.selected').data('id-product');
        copySelectedImage(selectedImageId, productId);
    });
    
    // Keyboard shortcuts
    $(document).on('keydown', function(e) {
        if (e.ctrlKey && e.key === 'c' && $('.image-item.selected').length) {
            e.preventDefault();
            $('#copy-image-btn').click();
        }
    });
});